<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Banner;

use Illuminate\Support\Str;

class BannersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products=Banner::get();
        return view('backend.banners.index')->with('products',$products);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.banners.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request,[
            'photo'=>'string|required',
        ]);

        $data=$request->all();
        
        $status=Banner::create($data);
        if($status){

            request()->session()->flash('success','Banner added Successfully');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('banners.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data=Banner::findOrFail($id);
        return view('backend.banners.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category=Banner::findOrFail($id);

        $this->validate($request,[
            'photo'=>'string|required',
        ]);
        $data=$request->all();
        $status=$Category->fill($data)->save();
        if($status){
            request()->session()->flash('success','Banner Successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('banners.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category=Banner::findOrFail($id);

        $status=$category->delete();

        if($status){
            request()->session()->flash('success','Banner successfully deleted');
        }
        else{
            request()->session()->flash('error','Error while deleting Banner');
        }
        return redirect()->route('banners.index');
    }
}
