<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Delivery;

use Illuminate\Support\Str;

class DeliveryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = Delivery::get();
        return view('backend.delivery.index')->with('products', $products);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.delivery.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request, [
            'name' => 'string|required',
            'photo' => 'string|required',
        ]);

        $data = $request->all();

        $status = Delivery::create($data);
        if ($status) {

            request()->session()->flash('success', 'Delivery Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('delivery.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Delivery::findOrFail($id);
        return view('backend.delivery.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category = Delivery::findOrFail($id);
        $this->validate($request, [
            'name' => 'string|required',
            'photo' => 'string|required',
        ]);
        $data = $request->all();
        $status = $Category->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Delivery Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('delivery.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = Delivery::findOrFail($id);

        $status = $category->delete();

        if ($status) {
            request()->session()->flash('success', 'Delivery successfully deleted');
        } else {
            request()->session()->flash('error', 'Error while deleting Delivery');
        }
        return redirect()->route('delivery.index');
    }
}
