<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\User;
use App\Models\Setting;
use App\Models\Reseller;
use App\Models\Seller;
use App\Models\Expense;
use App\Models\StatusControl;
use App\Models\ProductReview;
use App\Models\Product;
use App\Models\Supplier;
use App\Models\Notification;
use DB;
use Phparch\Fasterweb\WebFunction;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware("auth");
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $settings = DB::table('settings')->where('id', 1)->first();
        $totalorder = Order::count();
        $totaluser = User::count();
        $stat           = StatusControl::get();
        $Placed_order   = Order::where('status', 'New Order')->count();
        $Cancel_order   = Order::where('status', 'Cancel')->count();
        $confirm_order  = Order::where('status', 'Confirm')->count();
        $shipped_order  = Order::where('status', 'Shipped to Courier')->count();
        $Return         = Order::where('status', 'Return')->count();
        $DeliveryDone   = Order::where('status', 'Delivery Done')->count();
        $suppliers   = Supplier::count();
        $lowStockCount = Product::where('stock', '<=', 10)->count();
        $lowStockpro = Product::where('stock', '<=', 10)->limit(10)->get();


        $costprice = DB::table("order_details")
            ->join("orders", "order_details.order_id", "=", "orders.id")
            ->where("orders.status", "Delivery Done")
            ->sum(DB::raw("order_details.cost * order_details.quantity"));
        $totalprice = DB::table("order_details")
            ->join("orders", "order_details.order_id", "=", "orders.id")
            ->select("order.status")
            ->where("orders.status", "Delivery Done")
            ->sum(DB::raw("order_details.price * order_details.quantity"));
        $grossprofit = $totalprice - $costprice;
        $totaldiscount = DB::table("orders")
            ->where("status", "Delivery Done")
            ->sum("discount");
        $totalloss = Order::where("status", "Cancel")->sum("shipping_cost");
        $totalexpanse = Expense::sum("amount");
        $totalrev = $totalprice - $costprice - $totaldiscount - $totalloss;
        $netprofit =
            $totalprice -
            $costprice -
            $totaldiscount -
            $totalloss -
            $totalexpanse;

        $products = Notification::get();

        return view(
            "backend.index",
            compact(
                "totalrev",
                "totalorder",
                "stat",
                "Placed_order",
                "Cancel_order",
                "confirm_order",
                "DeliveryDone",
                "Return",
                "shipped_order",
                "totaluser",
                "netprofit",
                "settings",
                "suppliers",
                "totalexpanse",
                "lowStockCount",
                "lowStockpro",
                "products"
            )
        );
    }
    public function notificationread($id)
    {
        $products = Notification::findOrfail($id);
        $products->status = 1;
        $products->save();

        request()
            ->session()
            ->flash("success", "Marked as Read Successfully");

        return redirect()->back();
    }
    public function notificationdelete(Request $request, $id)
    {
        $products = Notification::findOrfail($id);
        $products->delete();
        request()
            ->session()
            ->flash("success", "Deleted Successfully");
        return redirect()->back();
    }
    public function media()
    {
        return view("backend.media");
    }

    public function customer()
    {
        // Subquery to fetch latest order for each user
        $subquery = Order::selectRaw(
            "user_id, MAX(created_at) as latest_order_created_at"
        )->groupBy("user_id");

        // Fetch users with their latest order
        $customers = User::joinSub($subquery, "latest_orders", function (
            $join
        ) {
            $join->on("users.id", "=", "latest_orders.user_id");
        })
            ->leftJoin("orders", function ($join) {
                $join
                    ->on("users.id", "=", "orders.user_id")
                    ->whereColumn(
                        "orders.created_at",
                        "=",
                        "latest_orders.latest_order_created_at"
                    );
            })
            ->select(
                "users.*",
                "orders.address as latest_order_address",
                "orders.ip_address as latest_order_ip"
            )
            ->orderByDesc("latest_orders.latest_order_created_at")
            ->paginate(10);

        return view("backend.customer", compact("customers"));
    }

    public function reviews()
    {
        $products = ProductReview::get();
        return view("backend.review", compact("products"));
    }
    public function resellers()
    {
        $products = Reseller::orderBy("status", "ASC")->get();
        return view("backend.resellers", compact("products"));
    }
    public function resellersread($id)
    {
        $products = Reseller::findOrfail($id);
        $products->status = 1;
        $products->save();

        request()
            ->session()
            ->flash("success", "Marked as Read Successfully");

        return redirect()->back();
    }
    public function reviewsDelete(Request $request, $id)
    {
        $products = ProductReview::findOrfail($id);
        $products->delete();
        request()
            ->session()
            ->flash("success", "Deleted Successfully");
        return redirect()->back();
    }
    public function reviewsactive(Request $request, $id)
    {
        $products = ProductReview::findOrfail($id);
        if ($products->status == 0) {
            $products->status = 1;
            request()
                ->session()
                ->flash("success", "Marked as Read ACti");
        } else {
            $products->status = 0;
        }
        $products->save();

        return redirect()->back();
    }
    public function resellersdelete($id)
    {
        request()
            ->session()
            ->flash("error", "Sorry! the action is not permitted in demo");

        return redirect()->back();
    }
    public function sellers()
    {
        $products = Seller::orderBy("status", "ASC")->get();
        return view("backend.sellers", compact("products"));
    }
    public function sellersread($id)
    {
        $products = Seller::findOrfail($id);
        $products->status = 1;
        $products->save();

        request()
            ->session()
            ->flash("success", "Marked as Read Successfully");

        return redirect()->back();
    }
    public function sellersdelete($id)
    {
        request()
            ->session()
            ->flash("error", "Sorry! the action is not permitted in demo");
        return redirect()->back();
    }

    public function banner()
    {
        $data = Setting::where("id", 1)->first();
        return view("backend.banner", compact("data"));
    }

    public function update(Request $request, $id)
    {
        $setting = Setting::findOrFail($id);
        $this->validate($request, [
            'banner_right' => 'nullable',
            'banner_left' => 'nullable',
            'banner_m' => 'nullable',
            'friday_sale_banner' => 'nullable',
        ]);
        $data = $request->all();
        $status = $setting->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Banner Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('banner.index');
    }
    public function general()
    {
        WebFunction::FasterAPI();
        $data = Setting::first();
        return view("backend.setting.general", compact("data"));
    }

    public function generalUpdate(Request $request, $id)
    {
        $setting = Setting::findOrFail($id);
        $this->validate($request, [
            'logo' => 'string|required',
            'footer_logo' => 'string|required',
            'website' => 'string|required',
        ]);
        $data = $request->all();
        $status = $setting->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Setting Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('general.index');
    }
    public function website()
    {
        $data = Setting::first();
        return view("backend.setting.color", compact("data"));
    }

    public function websiteUpdate(Request $request, $id)
    {
        $setting = Setting::findOrFail($id);
        $data = $request->all();
        $status = $setting->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Setting Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('website.index');
    }
    public function productview()
    {
        $data = Setting::first();
        return view("backend.setting.product", compact("data"));
    }

    public function productviewUpdate(Request $request, $id)
    {
        $setting = Setting::findOrFail($id);
        $data = $request->all();
        $status = $setting->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Website content Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('productview.index');
    }

    public function social()
    {
        $data = Setting::first();
        return view("backend.setting.social", compact("data"));
    }

    public function socialUpdate(Request $request, $id)
    {
        $setting = Setting::findOrFail($id);
        $data = $request->all();
        $status = $setting->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Social Link Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('social.index');
    }
    public function analytics()
    {
        $data = Setting::first();
        return view("backend.setting.analytics", compact("data"));
    }

    public function analyticsUpdate(Request $request, $id)
    {
        $setting = Setting::findOrFail($id);
        $data = $request->all();
        $status = $setting->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('analytics.index');
    }
}
