<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Page;

use Illuminate\Support\Str;

class PagesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = Page::get();
        return view('backend.pages.index')->with('products', $products);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.pages.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request, [
            'title' => 'string|required',
            'description' => 'string|required',
            'slug' => 'unique:pages,slug',
        ]);

        $data = $request->all();
        $data['slug'] = Str::slug($request->title, '-');

        $status = Page::create($data);
        if ($status) {

            request()->session()->flash('success', 'Page Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('pages.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Page::findOrFail($id);
        return view('backend.pages.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category = Page::findOrFail($id);
        $this->validate($request, [
            'title' => 'string|required',
            'description' => 'string|required',
            'slug' => 'string',
        ]);
        $data = $request->all();
        $status = $Category->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Page Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('pages.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = Page::findOrFail($id);

        $status = $category->delete();

        if ($status) {
            request()->session()->flash('success', 'Page successfully deleted');
        } else {
            request()->session()->flash('error', 'Error while deleting Page');
        }
        return redirect()->route('pages.index');
    }
}
