<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DeliveryTime;

use Illuminate\Support\Str;

class ScheduleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = DeliveryTime::get();
        return view('backend.schedule.index')->with('products', $products);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.schedule.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return json_encode($request->color);


        $this->validate($request, [
            'title' => 'string|required',
            'location' => 'string|required',
            'time' => 'string|required',
            'color' => 'string|required',
            'text_color' => 'string|required',
        ]);

        $data = $request->all();

        $status = DeliveryTime::create($data);
        if ($status) {

            request()->session()->flash('success', 'Delivery Schedule Successfully added');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('schedule.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = DeliveryTime::findOrFail($id);
        return view('backend.schedule.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Category = DeliveryTime::findOrFail($id);
        $this->validate($request, [
            'title' => 'string|required',
            'location' => 'string|required',
            'time' => 'string|required',
            'color' => 'string|required',
            'text_color' => 'string|required',
        ]);
        $data = $request->all();
        $status = $Category->fill($data)->save();
        if ($status) {
            request()->session()->flash('success', 'Delivery Schedule Successfully updated');
        } else {
            request()->session()->flash('error', 'Please try again!!');
        }
        return redirect()->route('schedule.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = DeliveryTime::findOrFail($id);

        $status = $category->delete();

        if ($status) {
            request()->session()->flash('success', 'Delivery Schedule successfully deleted');
        } else {
            request()->session()->flash('error', 'Error while deleting Delivery Schedule');
        }
        return redirect()->route('schedule.index');
    }
}
