<?php

namespace App\Http\Controllers;

use App\Models\Size;
use Illuminate\Http\Request;

class SizeController extends Controller
{
    /**
     * Display a listing of the sizes.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = Size::all();
        return view('backend.size.index', compact('products'));
    }

    /**
     * Show the form for creating a new size.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.size.create');
    }

    /**
     * Store a newly created size in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:sizes|max:255',
        ]);

        Size::create($request->all());

        return redirect()->route('size.index')
            ->with('success', 'Size created successfully.');
    }

    // Define other methods (edit, update, destroy) as needed
    public function destroy($id)
    {
        $products = Size::findOrFail($id);
        $products->delete();

        return redirect()->route('size.index')
            ->with('success', 'Size deleted successfully.');
    }
}
