<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Size;
use App\Models\ProductSizeVariation;
use App\Models\LiquidOilVariation;

use Illuminate\Support\Str;


class StockController extends Controller
{
    public function index()
    {
        $products = Product::orderBy("created_at", "DESC")->get();
        $liquidproducts = Product::orderBy("created_at", "DESC")->get();

        // Create an array to store size data for each product
        $size_data = [];
        $liquid_data = [];


        // Loop through each product to retrieve its size data
        foreach ($products as $product) {
            // Retrieve size data for the current product
            $size_data[$product->id] = ProductSizeVariation::where(
                "product_id",
                $product->id
            )->get();
        }

        foreach ($liquidproducts as $product) {
            // Retrieve size data for the current product
            $liquid_data[$product->id] = LiquidOilVariation::where(
                "product_id",
                $product->id
            )->get();
        }

        return view("backend.stock.index", compact("products", "size_data", "liquid_data"));
    }
    public function edit($id)
    {
        // Get all sizes
        $sizes = Size::all();

        // Find the product
        $product = Product::findOrFail($id);

        // Get size variations for the current product
        $sizev = ProductSizeVariation::where('product_id', $product->id)->get();

        // Get categories and brands
        $category = Category::where("is_parent", 1)->get();
        $brand = Brand::where("is_parent", 1)->get();

        return view("backend.stock.edit")
            ->with("product", $product)
            ->with("categories", $category)
            ->with("brands", $brand)
            ->with("sizevs", $sizev)
            ->with("sizes", $sizes); // Pass all sizes to the view
    }
    public function update(Request $request, $id)
    {
        $product = Product::findOrFail($id);
        $this->validate($request, [
            "size_id" => "nullable",
            "stock" => "numeric",
            "offer_price" => "nullable",
            "cost" => "",
            "discount" => "nullable|numeric",
        ]);

        $data = $request->all();
        $data["cost"] = $request->cost;

        $status = $product->fill($data)->save();

        // Update size variations
        $size_ids = $request->input('size_id', []);
        $size_prices = $request->input('size_price', []);
        $size_stocks = $request->input('size_stock', []);

        foreach ($size_ids as $index => $size_id) {
            $product->product_size_variations()->updateOrCreate(
                ['size_id' => $size_id],
                [
                    'price' => $size_prices[$index],
                    'stock' => $size_stocks[$index],
                ]
            );
        }
        if ($status) {
            request()
                ->session()
                ->flash("success", "Purchase Successfully updated");
        } else {
            request()
                ->session()
                ->flash("error", "Please try again!!");
        }
        return redirect()->route("stocks.index");
    }
    public function destroy($id)
    {
        request()->session()->flash('error', 'Sorry!');
        return redirect()->route("stocks.index");
    }
}
