<?php

namespace App\Http\Middleware;

use Closure;

class User
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if($request->user()->role=='user'){
            if($request->user()->verified== 0){
                return redirect()->route('otp');
            }
            else{
                return $next($request);
            }
        }
        else{
            request()->session()->flash('error','You do not have any permission to access this page');
            return redirect('login');
        }
    }
}
