<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\Password;


class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = 'dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    public function login(Request $request)
    {
        $action = $request->input('action');

        if ($action == 'Login') {
            $credentials = $request->only('email', 'password');
            if (Auth::attempt($credentials)) {
                // Authentication passed...
                return redirect()->intended('/user');
            } else {
                // Authentication failed...
                return back()->withErrors([
                    'email' => 'Invalid email and password pleas try again',
                ]);
            }
        } else if ($action == 'Reset') {
            // Get the email address from the request
            $email = $request->input('email');

            // Generate a password reset token and send the password reset email
            $response = Password::sendResetLink(['email' => $email]);

            // Redirect back with a success message
            if ($response == Password::RESET_LINK_SENT) {
                return back()->with('success', 'A password reset link has been sent to your email address.');
            } else {
                return back()->withErrors([
                    'email' => 'Unable to send password reset email. Please try again later.',
                ]);
            }
        } else {
            return back()->with('error', 'Something is wrong!!!');
        }
    }
}
