<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Notification;
use Phparch\Fasterweb\WebFunction;

class NotificationController extends Controller
{
    public function index()
    {
        $products = Notification::get();
        return view('backend.index', compact('products'));
    }

    public function notificationread($id)
    {
        $products = Notification::findOrfail($id);
        $products->status = 1;
        $products->save();

        request()->session()->flash('success', 'Marked as Read Successfully');

        return redirect()->back();
    }

    public function notificationDelete(Request $request, $id)
    {
        $products = ProductReview::findOrfail($id);
        $products->delete();
        request()->session()->flash('success', 'Deleted Successfully');
        return redirect()->back();
    }
}
