<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;
use App\Models\Api;
use App\Models\Shipping;
use App\Models\State;
use App\Models\Order;
use App\Models\SmsTemplate;
use App\Models\PaymentRequest;
use App\Models\Setting;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class ProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('user.index');
    }
    public function otp(Request $request)
    {
        if($request->has('paymentID') && $request->has('status')) {
            
            $paymentID = $request->input('paymentID');
            $status = $request->input('status');
            if($status == 'success'){
                $header =$this->authHeaders();

                $body_data = array(
                    'paymentID' => $paymentID,
                );
                $body_data_json=json_encode($body_data);
    
                $response = $this->curlWithBody('/tokenized/checkout/payment/status',$header,'POST',$body_data_json);
                
                $res_array = json_decode($response,true);
    
                //dd($res_array);
                if(isset($res_array)){
                    if($res_array['merchantInvoice'] == $settings->order_prefix.$data->id && $res_array['amount'] == $data->total_amount && $res_array['verificationStatus'] == 'Complete'){
                        $header =$this->authHeaders();

                        $body_data = array(
                            'paymentID' => $res_array['paymentID']
                        );
                        $body_data_json=json_encode($body_data);

                        $response = $this->curlWithBody('/tokenized/checkout/execute',$header,'POST',$body_data_json);

                        $res_array = json_decode($response,true);

                        
                        //dd($res_array);
                        if(array_key_exists("statusCode",$res_array) && $res_array['statusCode'] != '0000'){
                            request()->session()->flash('error', $res_array['statusMessage']);
                            return view('confirm',compact('data'));
                        }                
                        elseif(isset($res_array['trxID'])){
                            $data->trxid = $res_array['trxID'];
                            $data->paymentID = $res_array['paymentID'];
                            $data->payment_status = 'paid';
                            $data->payment = $res_array['amount'];
                            $data->save();
                        }
                        else{
                            request()->session()->flash('error', 'Something is wrong!! Payment not marked as Completed');
                        }
                        
                        
                    }
                    else{
                        $data->payment_status = 'unpaid';
                        $data->save();
                    }
                }
            }
            
        }
        return view('user.otp');
    }
    public function setting()
    {
        $data=User::findOrfail(Auth()->user()->id);
        return view('user.setting',compact('data'));
    }
    public function settingupdate(Request $request)
    {
        $Category=User::findOrfail(Auth()->user()->id);
        if($Category->phone != $request->phone){
            $Category->verified = 0;
            $smsapi=Api::where('id',1)->first();
            if($smsapi->sms_status == 'on'){
                $randomNumber = random_int(1000, 9999);
                $Category->otp = $randomNumbe;
                $otp = $randomNumber;
                $message='Your%20OTP:'.$otp.'';
                $phonenumber = $data['phone'];
                $message = urlencode($message);
                $phoneNumber = "88".$phonenumber; // The phone number to send the message to
                //dd($phoneNumber);
                $senderId = $smsapi->sms_sender_id; // Your approved Sender ID
                $apiKey = $smsapi->sms_api_key; // Your API key

                // Build the URL
                $url = "https://isms.mimsms.com/smsapi?api_key=".$apiKey."&type=text&contacts=".$phoneNumber."&senderid=".$senderId."&msg=".$message;

                // Initialize cURL
                $ch = curl_init();

                // Set cURL options
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                // Execute the request
                $response = curl_exec($ch);

                // Close the cURL session
                curl_close($ch);
                $Category->save();
                }
            }
            
        $data=$request->all();
        if($request->hasFile('photo'))
        {
            // Get filename with the extension
            $filenameWithExt = $request->file('photo')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('photo')->getClientOriginalExtension();
            // Filename to store
            $fileNameToStore = $filename.'_'.time().'.'.$extension;
            // Upload image
            $path = $request->file('photo')->storeAs('public/user', $fileNameToStore);
            $data['photo'] = $fileNameToStore;
        } 
        $status=$Category->fill($data)->save();
        if($status){
            request()->session()->flash('success','Successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->back();
    }
    public function password()
    {
        $data=User::findOrfail(Auth()->user()->id);
        return view('user.password',compact('data'));
    }
    public function passwordupdate(Request $request)
    {
        $data = user::where('id','=',Auth()->user()->id)->first();
        if(Hash::check($request->password, $data->password)){
            if($request->confirm_password == $request->re_confirm_password)
            {
                $data->password = Hash::make($request->confirm_password);
                $data->save();
                request()->session()->flash('success','Password Changed Successfully!');
                return redirect()->back();
            }
            else{
                request()->session()->flash('error','New password not match!');
                return redirect()->back();
            }
        }
        request()->session()->flash('error','Current password not match!');
        return redirect()->back();
    }
    public function order()
    {
        $products=Order::where('phone', Auth()->user()->phone)->get();
        return view('user.order')->with('products',$products);
    }
    public function payreq()
    {
        $products=Order::where('phone', Auth()->user()->phone)->get();
        $payreq = [];
        foreach ($products as $key => $value) {
            $findreq = PaymentRequest::where('order_id', $value->id)->get();
            $payreq[$key] = $findreq;
        }
        //dd($payreq);

        
        return view('user.payrequest')->with('payreq',$payreq);
    }
    public function otpverify(Request $request)
    {
        //return $request->all();
        $products=User::findOrfail(Auth()->user()->id);
        if($products->otp == $request->otp){
            $products->verified = 1;
            $products->save();
            if($request->has('order_id')){
                $orderId = $request->get('order_id');
                return redirect()->route('order.received', $orderId);
            }
            if($request->has('payment')){
                if($request->get('order_id') == 'bkash'){
                    
                }
                else{
                    $orderId = $request->get('order_id');
                    return redirect()->route('order.received', $orderId);
                }
            }
            return redirect()->route('user');
        }
        else{
            request()->session()->flash('error','Wrong OTP!!');
            return redirect()->back();
        }
    }


 
}
