<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Str;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(Auth()->user()->role == 'admin'){
        $products = User::whereNotIn('id', [1])->get();
        return view('backend.user.index')->with('products',$products);
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if(Auth()->user()->role == 'admin'){
        return view('backend.user.create');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if(Auth()->user()->role == 'admin'){
            $this->validate($request,[
                'name' => ['required', 'string', 'max:255'],
                'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                'password' => ['required', 'string', 'min:8', 'confirmed'],
            ]);
            

            $access = json_encode($request->access);
            $data=$request->all();
            $data['access'] = $access;
            //dd($data);
    
            $status= User::create([
                'name' => $data['name'],
                'email' => $data['email'],
                'phone' => $data['phone'],
                'role' => $data['role'],
                'verified' => $data['verified'],
                'access' => $data['access'],
                'password' => Hash::make($data['password']),
            ]);
            if($status){
    
                request()->session()->flash('success','User Successfully added');
            }
            else{
                request()->session()->flash('error','Please try again!!');
            }
            return redirect()->route('user.index');
        }

    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
            $data=User::findOrFail($id);
            return view('backend.user.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //return $request->all();
        $User=User::findOrFail($id);
        $this->validate($request,[
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255'],
            'password' => ['nullable', 'string', 'min:8'],
        ]);
       

        if($request->password == null){
            $User->name = $request->name;
            $User->email = $request->email;
            $User->phone = $request->phone;
            
            if(Auth()->user()->role == 'admin'){
                $User->verified = $request->verified;
                $User->role = $request->role;
                $User->access = $request->access;
    
            }
            $status=$User->save();
        }else{
            $data=$request->all();
            $data['password']=Hash::make($data['password']);
            $status=$User->fill($data)->save();
        }

        if($status){
            request()->session()->flash('success','User Successfully updated');
        }
        else{
            request()->session()->flash('error','Please try again!!');
        }
        return redirect()->route('user.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if(Auth()->user()->role == 'admin'){
            $category=User::findOrFail($id);

            $status=$category->delete();

            if($status){
                request()->session()->flash('success','User successfully deleted');
            }
            else{
                request()->session()->flash('error','Error while deleting User');
            }
            return redirect()->route('user.index');
        }
    }
}
