<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Warehouse;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class WarehouseController extends Controller
{
    // Display a listing of the warehouses.
    public function index()
    {
        $warehouses = Warehouse::with('user')->get();
        return view('backend.warehouses.index', compact('warehouses'));
    }

    // Show the form for creating a new warehouse.
    public function create()
    {
        $users = User::where('role', 'shopmanager')->get();
        return view('backend.warehouses.create', compact('users'));
    }

    // Store a newly created warehouse in storage.
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'location' => 'nullable|string|max:255',
            'user_id' => 'required|exists:users,id',

        ]);

        Warehouse::create([
            'name' => $request->name,
            'location' => $request->location,
            'phone' => $request->phone,
            'user_id' => $request->user_id,
        ]);

        return redirect()->route('warehouses.index')->with('success', 'Warehouse created successfully.');
    }

    // Show the form for editing the specified warehouse.
    public function edit($id)
    {
        $warehouse = Warehouse::findOrFail($id);
        $users = User::where('role', 'shopmanager')->get();
        return view('backend.warehouses.edit', compact('warehouse', 'users'));
    }

    // Update the specified warehouse in storage.
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'location' => 'nullable|string|max:255',
            'user_id' => 'required|exists:users,id',
        ]);

        $warehouse = Warehouse::findOrFail($id);
        $warehouse->update([
            'name' => $request->name,
            'location' => $request->location,
            'phone' => $request->phone,
            'user_id' => $request->user_id,
        ]);

        return redirect()->route('warehouses.index')->with('success', 'Warehouse updated successfully.');
    }

    // Remove the specified warehouse from storage.
    public function destroy(Warehouse $warehouse)
    {
        $warehouse->delete();

        return redirect()->route('warehouses.index')
            ->with('success', 'Warehouse deleted successfully.');
    }
}
