<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Setting;
use App\Models\User;
use App\Models\OrderDetail;
use App\Models\Order;
use App\Models\Expense;
use App\Models\ProductSizeVariation;
use App\Models\LiquidOilVariation;
use Auth;
use Carbon;
use DB;
use Illuminate\Support\Facades\Hash;
use URL;

use Illuminate\Support\Str;


class WholesaleController extends Controller
{
    public function index()
    {
        $products = Product::where("product_type", "wholesale")->orderBy("created_at", "DESC")->get();
        $liquidproducts = Product::orderBy("created_at", "DESC")->get();

        // Create an array to store size data for each product
        $size_data = [];
        $liquid_data = [];


        // Loop through each product to retrieve its size data
        foreach ($products as $product) {
            // Retrieve size data for the current product
            $size_data[$product->id] = ProductSizeVariation::where(
                "product_id",
                $product->id
            )->get();
        }

        foreach ($liquidproducts as $product) {
            // Retrieve size data for the current product
            $liquid_data[$product->id] = LiquidOilVariation::where(
                "product_id",
                $product->id
            )->get();
        }

        return view("backend.wholesale.index", compact("products", "size_data", "liquid_data"));
    }
    public function create(Request $request)
    {
        // Get the user ID from the request
        $userId = $request->user()->id;

        // Query the user based on the user ID
        $user = User::find($userId);

        // Retrieve staff users
        $results = User::where("role", "staff")->get();

        // Fetch products with their size variations
        $products = Product::where("product_type", "wholesale")->get();

        // Pass data to the view
        return view(
            "backend.wholesale.create",
            compact("products", "user", "results")
        );
    }
    public function store(Request $request)
    {
        //return $request->all();

        $this->validate($request, [
            "customerName" => "required",
            "customerPhone" => "required",
            "customerAddress" => "required",
            "sub_total" => "required",
            "shipping_cost" => "required",
            "discount" => "required",
            "total_amount" => "required",
            "fbwaorder" => "",
        ]);

        $general = Setting::where("id", 1)->first();

        $order = new Order();
        $order_data = $request->all();
        $order_data["order_number"] = $general->order_prefix . strtoupper(Str::random(10));
        $order_data["shipping_cost"] = $request->shipping_cost;
        $order_data["sub_total"] = $request->sub_total;
        $order_data["total_amount"] = $request->total_amount;
        $order_data["discount"] = $request->discount;
        $order_data["payment"] = $request->payment;
        $order_data["status"] = "New Order";
        $order_data["payment_method"] = "cod";
        $order_data["payment_status"] = "Unpaid";
        $order_data["first_name"] = $request->customerName;
        $order_data["phone"] = $request->customerPhone;
        $order_data["address"] = $request->customerAddress;
        $order_data["note"] = $request->customerNote;
        $order_data["fbwaorder"] = $request->facebook_order;

        $user = User::where('role', 'staff')->inRandomOrder()->first();
        if ($user) {
            $order_data['assign_user_id'] = $user->id;
        } else {
            $order_data['assign_user_id'] = 1;
        }


        $order->fill($order_data);
        //dd($request->order);
        $status = $order->save();
        if (!Auth::check()) {
            $user = User::firstOrCreate(
                ['phone' => $order->phone],
                [
                    'name' => $order->first_name,
                    'verified' => 1,
                    'current_address' => $request->customerAddress,
                    'password' => Hash::make('12345678')
                ]
            );
        }

        // Assuming $order is already defined somewhere in your code
        $order = Order::findOrFail($order->id); // Fetch the specific Order using findOrFail

        $data = ['user_id' => auth()->user()->id]; // Prepare data to update

        $order->update($data); // Update the Order record with the new user_id
        foreach ($request->order as $key => $row) {
            //dd($row['product_id']);
            $product = Product::where("id", $row["product_id"])->first();
            $cart = new OrderDetail();
            $cart->product_id = $product->id;
            $cart->order_id = $order->id;
            $cart->cost = $product->cost;
            $cart->price = $product->offer_price;
            $cart->quantity = $row["quantity"];
            if (isset($row["size"])) {
                $cart->size = $row["size"];
            }
            if (isset($row["color"])) {
                $cart->color = $row["color"];
            }
            $cart->amount = $product->offer_price * $row["quantity"];
            $cart->save();
        }

        if ($status) {
            request()
                ->session()
                ->flash("success", "Successfully added");
        } else {
            request()
                ->session()
                ->flash("error", "Please try again!!");
        }
        return redirect()->route("wholesale.index");
    }
    public function wreport(Request $request)
    {
        $created_at = Carbon\Carbon::today()->format("d-m-Y");
        $fromDate = $created_at;
        $todate = $created_at;
        $statusNew = $request->status;

        // Fetch order details
        $orderDetails = DB::table("order_details")
            ->join("orders", "order_details.order_id", "=", "orders.id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->select(
                "order_details.product_id",
                "order_details.size",
                "order_details.color",
                "order_details.quantity"
            )
            ->where("products.product_type", "wholesale") // Filter based on product_type in products table
            ->whereIn("orders.status", [
                "Confirm",
                "Shipped to Courier",
                "New order",
                "Delivery Done",
            ])
            ->get();


        // Fetch products including soft-deleted ones, but only those with 'wholesale' type
        $productIds = $orderDetails->pluck('product_id')->unique();
        $products = Product::withTrashed()
            ->whereIn('id', $productIds)
            ->where('product_type', 'wholesale')
            ->get()
            ->keyBy('id');

        $data = [];

        foreach ($orderDetails as $value) {
            $product = $products->get($value->product_id);

            // Skip if product is not found or not of type 'wholesale'
            if (!$product) {
                continue;
            }

            $key = "{$value->product_id}-{$value->size}-{$value->color}";

            if (isset($data[$key])) {
                $data[$key]["quantity"] += $value->quantity;
            } else {
                $data[$key] = [
                    "id" => $value->product_id,
                    "product_name" => $product->title ?? 'Product Deleted',
                    "sku" => $product->SKU ?? '',
                    "size" => $value->size,
                    "color" => $value->color,
                    "quantity" => $value->quantity,
                ];
            }
        }

        // Sort the array by product name
        usort($data, function ($a, $b) {
            return $a["product_name"] <=> $b["product_name"];
        });

        return view("backend.wholesale.report", compact("data", "fromDate", "todate", "statusNew"));
    }

    public function wreportdate(Request $request)
    {
        $data = [];
        $fromDate = $request->fromDate;
        $todate = $request->todate;
        $statusNew = $request->status;

        $productType = 'wholesale'; // Define the product type you want to filter by

        $dataasd = DB::table("order_details")
            ->join("orders", "order_details.order_id", "=", "orders.id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->where("orders.status", $statusNew)
            ->whereBetween("orders.created_at", [
                Carbon\Carbon::parse($fromDate)->startOfDay(),
                Carbon\Carbon::parse($todate)->endOfDay(),
            ])
            ->where("products.product_type", $productType) // Filter by product_type
            ->get();


        foreach ($dataasd as $key => $value) {
            $prcasd = Product::where("id", $value->product_id)
                ->withTrashed()
                ->where('product_type', 'wholesale')
                ->first();
            $data[$key]["id"] = $value->product_id;
            $data[$key]["product_name"] = $prcasd->title ?? 'Product Deleted';
            $data[$key]["sku"] = $prcasd->SKU ?? '';
            $data[$key]["size"] = $value->size;
            $data[$key]["color"] = $value->color;
            $data[$key]["quantity"] = $value->quantity;
        }
        $uniqueProducts = [];

        // Loop through each product in the data array and combine the quantities
        foreach ($data as $product) {
            $key =
                $product["id"] .
                "-" .
                $product["size"] .
                "-" .
                $product["color"];

            if (isset($uniqueProducts[$key])) {
                $uniqueProducts[$key]["quantity"] += $product["quantity"];
            } else {
                $uniqueProducts[$key] = $product;
            }
        }

        // Sort the array by product name
        usort($uniqueProducts, function ($a, $b) {
            return $a["product_name"] <=> $b["product_name"];
        });
        $data = $uniqueProducts;
        return view(
            "backend.wholesale.report",
            compact("data", "fromDate", "todate", "statusNew")
        );
    }

    public function wfullreport()
    {
        $created_at = Carbon\Carbon::today();
        $created_at = $created_at->format("d-m-Y");
        $fromDate = $created_at;
        $todate = $created_at;

        $total_order = Order::join('order_details', 'orders.id', '=', 'order_details.order_id')
            ->join('products', 'order_details.product_id', '=', 'products.id')
            ->where('products.product_type', 'wholesale')
            ->count();



        $total_deliver = Order::join('order_details', 'orders.id', '=', 'order_details.order_id')
            ->join('products', 'order_details.product_id', '=', 'products.id')
            ->where('orders.status', 'Delivery Done')
            ->where('products.product_type', 'wholesale')
            ->count();

        $total_pending = Order::join('order_details', 'orders.id', '=', 'order_details.order_id')
            ->join('products', 'order_details.product_id', '=', 'products.id')
            ->whereNotIn('orders.status', [
                'Cancel',
                'Delivery Done',
            ])
            ->where('products.product_type', 'wholesale')
            ->count();

        $total_cancel = Order::join('order_details', 'orders.id', '=', 'order_details.order_id')
            ->join('products', 'order_details.product_id', '=', 'products.id')
            ->where('orders.status', 'Cancel')
            ->where('products.product_type', 'wholesale')
            ->count();

        $productinsale = DB::table("order_details")
            ->join("orders", "order_details.order_id", "=", "orders.id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->where('products.product_type', 'wholesale') // Filter by product_type
            ->sum("order_details.quantity"); // Sum up the quantity

        $productsale = DB::table("order_details")
            ->join("orders", "order_details.order_id", "=", "orders.id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->whereNotIn("orders.status", ["Cancel", "Delivery Done"]) // Filter out specific statuses
            ->where("products.product_type", "wholesale") // Filter by product_type
            ->sum("order_details.quantity"); // Sum up the quantity

        $productdelivery = DB::table("order_details")
            ->join("orders", "order_details.order_id", "=", "orders.id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->where("orders.status", "Delivery Done")
            ->where("products.product_type", "wholesale") // Filter by product_type
            ->sum("order_details.quantity");

        $productCancel = DB::table("order_details")
            ->join("orders", "order_details.order_id", "=", "orders.id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->where("orders.status", "Cancel")
            ->where("products.product_type", "wholesale") // Filter by product_type
            ->sum("order_details.quantity");


        $costprice = DB::table("order_details")
            ->join("orders", "order_details.order_id", "=", "orders.id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->where("orders.status", "Delivery Done")
            ->where("products.product_type", "wholesale") // Filter by product_type
            ->sum(DB::raw("order_details.cost * order_details.quantity"));

        $totalprice = DB::table("orders")
            ->join("order_details", "orders.id", "=", "order_details.order_id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->where("orders.status", "Delivery Done")
            ->where("products.product_type", "wholesale") // Filter by product_type
            ->sum("orders.sub_total");

        $grossprofit = $totalprice - $costprice;
        $totaldiscount = DB::table("orders")
            ->join("order_details", "orders.id", "=", "order_details.order_id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->where("orders.status", "Delivery Done")
            ->where("products.product_type", "wholesale") // Filter by product_type
            ->sum("orders.discount"); // Sum up the discount


        $totalloss = DB::table("orders")
            ->join("order_details", "orders.id", "=", "order_details.order_id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->where("orders.status", "Cancel")
            ->where("products.product_type", "wholesale") // Filter by product_type
            ->sum("orders.shipping_cost"); // Sum up the shipping_cost

        $totalexpanse = Expense::sum("amount");
        $grosssale = $totalprice - $costprice - $totaldiscount - $totalloss;
        $netprofit =
            $totalprice -
            $costprice -
            $totaldiscount -
            $totalloss -
            $totalexpanse;

        $data = [];

        // Fetch data from the database
        $dataasd = DB::table("order_details")
            ->join("orders", "order_details.order_id", "=", "orders.id")
            ->join("products", "order_details.product_id", "=", "products.id") // Join with products table
            ->where("orders.status", "Delivery Done")
            ->select("order_details.*", "products.SKU", "products.title") // Select relevant fields
            ->get();

        // Initialize an array to accumulate quantities for unique products
        $uniqueProducts = [];

        // Process each record
        foreach ($dataasd as $value) {
            $key = $value->product_id . "-" . $value->size . "-" . $value->color;

            if (isset($uniqueProducts[$key])) {
                $uniqueProducts[$key]['quantity'] += $value->quantity;
            } else {
                $uniqueProducts[$key] = [
                    'id' => $value->product_id,
                    'product_name' => $value->title,
                    'sku' => $value->SKU,
                    'size' => $value->size,
                    'color' => $value->color,
                    'quantity' => $value->quantity,
                ];
            }
        }

        // Sort the array by product name
        usort($uniqueProducts, function ($a, $b) {
            return $a['product_name'] <=> $b['product_name'];
        });

        // Output the sorted and combined data
        $data = $uniqueProducts;


        return view(
            "backend.wholesale.fullreport",
            compact(
                "fromDate",
                "data",
                "productCancel",
                "productinsale",
                "productdelivery",
                "total_pending",
                "todate",
                "total_order",
                "total_deliver",
                "total_cancel",
                "productsale",
                "costprice",
                "totalprice",
                "totaldiscount",
                "totalloss",
                "totalexpanse",
                "grosssale",
                "grossprofit",
                "netprofit"
            )
        );
    }
    public function destroy($id)
    {
        request()->session()->flash('error', 'Sorry! ');
        return redirect()->route("wholesale.index");
    }
}
