<?php

namespace App\Library;

use Exception;

class UddoktaPay
{
    public static function init_payment($requestData)
    {
        $apiUrl = "https://sandbox.uddoktapay.com/api/checkout-v2";
        $apiKey = env('UDDOKTA_PAY_API_KEY');

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $apiUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($requestData),
            CURLOPT_HTTPHEADER => [
                "RT-UDDOKTAPAY-API-KEY: 982d381360a69d419689740d9f2e26ce36fb7a50" ,
                "accept: application/json",
                "content-type: application/json"
            ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            throw new Exception("cURL Error #: " . $err);
        } else {
            $result = json_decode($response, true);
            if (isset($result['status']) && isset($result['payment_url'])) {
                return $result['payment_url'];
            } else {
                $message = isset($result['message']) ? $result['message'] : 'Unknown error';
                throw new Exception($message);
            }
        }
    }
}

