<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LiquidOilVariation extends Model
{
    use HasFactory;

    protected $fillable = [
        'liquid_id',
        'product_id', // Add product_id to the fillable attributes
        'option_name',
        'option_value',
        'price',
        'stock',
    ];

    public function liquid()
    {
        return $this->belongsTo(Liquid::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
