<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderDetail extends Model
{
    protected $fillable=['product_id', 'order_id', 'cost', 'price', 'status', 'quantity', 'amount', 'size', 'color','liquid_id'];
    
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
    public function order(){
        return $this->belongsTo(Order::class,'order_id');
    }
    public function sizeVariations()
    {
        return $this->hasMany(SizeVariation::class);
    }
}
