<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Product;
use App\Models\LiquidOilVariation;
use App\Models\ProductSizeVariation;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use SoftDeletes;

    protected $fillable=['meta','warehouse_id','refundTrxID','unit','type','freeshipping','bkashpar','par_price','paymentID','bank','cod','SKU','color_id', 'title', 'friday_sale','gallery','slug', 'summary', 'description', 'specification', 'photo', 'video', 'stock', 'color', 'size', 'status', 'price','wholesale_price','wholesale', 'offer_price', 'cost', 'discount', 'is_featured', 'cat_id', 'supplier_id','child_cat_id','br_id'];

    public function colors()
    {
        return $this->hasMany(Color::class);
    }

    public function product_size_variations() {

        return $this->hasMany(ProductSizeVariation::class,'product_id');
    }
    public function colorVariations()
    {
        return $this->hasMany(ProductColorVariation::class,'product_id');
    }

    public function variations()
    {
        return $this->hasMany(LiquidOilVariation::class);
    }

    public function sizeVariations()
    {
     return $this->hasMany(ProductSizeVariation::class);
    }
    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }
    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }



}
