<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Product;

class ProductSizeVariation extends Model
{
    protected $table = 'product_size_variation';

    protected $fillable = [
        'product_id',
        'size_id',
        'stock',
        'price',
    ];

    // Optionally define any relationships or additional methods here

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function size()
    {
        return $this->belongsTo(Size::class);
    }
    
}
