<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Supplier extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'phone',
        'address',
        'company_name',
        'email',
        'balance',
        'payment_info',
        'status',
    ];
    
    public function expenses()
    {
        return $this->hasMany(Expense::class);
    }
}
