<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductSizeVariationTable extends Migration
{
    public function up()
    {
        Schema::create('product_size_variation', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->foreignId('size_id')->constrained()->onDelete('cascade');
            $table->integer('stock')->default(0);
            $table->decimal('price', 10, 2)->default(0.00); // Add the 'price' column with default value 0.00
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('product_size_variation');
    }
}
