@extends('backend.layouts.app')
@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Api Controller</h4>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="row">
        <div class="col-lg-6 col-sm-6 col-12">
            <div class="card">
                <div class="card-body">
                    <h3 for="" class="text-center">Redx Access</h3><br><br>
                    <form action="{{ route('redxUpdate')}}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        <div class="row">

                            <div class="col-lg-12 col-sm-12 col-12">

                                <div class="form-group">
                                    <label>API Base URL</label>
                                    <input type="text" name="redx_api_base_url" value="" placeholder="https://openapi.redx.com.bd/v1.0.0-beta/" required>
                                    @error('redx_api_base_url')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>API Access Token</label>
                                    <input type="text" name="redx_api_access_token" value="" placeholder="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiI3Nzc2MjAiLCJpYXQiOjEjIwLdqVCnSDJoodNXe1NNOU" required>
                                    @error('redx_api_access_token')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>

                            </div>

                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-submit me-2">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@push('styles')
@endpush

