@extends('backend.layouts.app')

@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Bkash Refund Controller</h4>
            <h6>Manage your Bkash Refund</h6>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-sm-12 col-12">
            <div class="card">
                <div class="card-body">
                    <h3 for="" class="text-center">Refund Proccess</h3><br><br>
                    <form action="{{ route('bkash.refund')}}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        <div class="row">
                            <div class="col-lg-6 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Order ID</label>
                                    <input type="text" name="id" value="" placeholder="">
                                    @error('id')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Transaction ID</label>
                                    <input type="text" name="trxID" value="" placeholder="">
                                    @error('trxID')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Payment ID</label>
                                    <input type="text" name="paymentID" value="" placeholder="">
                                    @error('paymentID')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Amount</label>
                                    <input type="number" name="amount" value="" placeholder="">
                                    @error('amount')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>SKU (coma separated)</label>
                                    <input type="text" name="sku" value="" placeholder="">
                                    @error('sku')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Reason</label>
                                    <input type="text" name="reason" value="" placeholder="">
                                    @error('reason')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-submit me-2">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    @if($message != '' && isset($message))
    <div class="card alert-success">
        <div class="card-body ">
            <ul>
                @foreach($message as $key => $row)
                <li>{{$key}} : {{$row}}</li>
                @endforeach
            </ul>
        </div>
    </div>
    @endif
</div>
@endsection
@push('styles')

@endpush


@push('scripts')

<script>
$(document).ready(function() {

    $('.datanews').DataTable({
        "bFilter": true,
        "sDom": 'fBtlpi',
        'pagingType': 'numbers',
        "ordering": true,
        "select": true,

        "language": {
            search: ' ',
            sLengthMenu: '_MENU_',
            searchPlaceholder: "Search...",
            info: "_START_ - _END_ of _TOTAL_ items",
        },
        "buttons": [{
                extend: 'csv',
                title: 'Product Inventory',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
            },
            {
                extend: 'excel',
                title: 'Product List',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                }
            },
            {
                extend: 'pdfHtml5',
                title: 'Product Inventory',
                exportOptions: {
                    columns: "thead th:not(.noExport)"
                },
            },
        ],
        initComplete: (settings, json) => {
            $('.dataTables_filter').appendTo('#tableSearch');
            $('.dataTables_filter').appendTo('.search-input');
        },



    });
});
</script>
@endpush