@extends('backend.layouts.app')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Api Controller</h4>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="row">
        <div class="col-lg-6 col-sm-6 col-12">
            <div class="card">
                <div class="card-body">
                
                <div class="container">
        <h1>Current Balance</h1>
        <div class="balance" id="current-balance">
            Loading...
        </div>
    </div>
                    <h3 for="" class="text-center">SteadFast Access</h3><br><br>
                    <form action="{{ route('steadFastUpdate')}}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        <div class="row">

                            <div class="col-lg-12 col-sm-12 col-12">

                                <div class="form-group">
                                    <label>API URL</label>
                                    <input type="text" name="api_url" value="" placeholder="https://portal.steadfast.com.bd/api/v1/" required>
                                    @error('api_url')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>API Key</label>
                                    <input type="text" name="steadfast_api_key" value="" placeholder="gca198aeaaxculxyfymkuiurcerjretyecv7vu" required>
                                    @error('steadfast_api_key')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>Secret Key</label>
                                    <input type="text" name="steadfast_secret_key" value="" placeholder="pasu8semuymiyiuimunyrtrersctytuyik" required>
                                    @error('steadfast_secret_key')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>

                            </div>

                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-submit me-2">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
<script>
        $(document).ready(function() {
            // AJAX request to fetch the balance
            $.ajax({
                url: '{{ route("getBalance") }}',
                method: 'GET',
                success: function(response) {
                    // Update the balance on success
                    $('#current-balance').text('Current Balance: ' + response.current_balance);
                },
                error: function(xhr, status, error) {
                    // Handle error
                    console.error(xhr.responseText);
                    $('#current-balance').text('Failed to fetch balance.');
                }
            });
        });
    </script>
@push('styles')
@endpush

