@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Fixed Banner  Edit</h4>
            <h6>Edit Fixed Banner</h6>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('banner.update', $data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="col-lg-12 col-sm-12 col-12">
                            <div class="form-group">
                                <img src="{{URL::to('')}}/{{$data->banner_left}}" alt="">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <label>Home Banner</label>
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <a id="lfm23412" data-input="thumbnail1" data-preview="holder1" class="btn btn-primary">
                                        <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                </span>
                                <input id="thumbnail1" class="form-control" name="banner_left" value="{{$data->banner_left}}" type="text" >
                            </div>
                            <div id="holder1" style="margin-top:15px;max-height:100px;">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="col-lg-12 col-sm-12 col-12">
                            <div class="form-group">
                                <img src="{{URL::to('')}}/{{$data->banner_right}}" alt="">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <label>Home Banner</label>
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <a id="lfm234" data-input="thumbnail" data-preview="holder" class="btn btn-primary">
                                        <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                </span>
                                <input id="thumbnail" class="form-control" name="banner_right" value="{{$data->banner_right}}" type="text" >
                            </div>
                            <div id="holder" style="margin-top:15px;max-height:100px;">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="col-lg-12 col-sm-12 col-12">
                            <div class="form-group">
                                <img src="{{URL::to('')}}/{{$data->banner_m}}" alt="">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <label>Home Banner</label>
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <a id="lfm23415" data-input="thumbnail33" data-preview="holder45656" class="btn btn-primary">
                                        <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                </span>
                                <input id="thumbnail3663" class="form-control" name="banner_m" value="{{$data->banner_m}}" type="text" >
                            </div>
                            <div id="holder45656" style="margin-top:15px;max-height:100px;">
                            </div>
                        </div>
                    </div>
                   
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="col-lg-12 col-sm-12 col-12">
                            <div class="form-group">
                                <img src="{{URL::to('')}}/{{$data->friday_sale_banner}}" alt="">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <label>Friday Sale Banner (Single Image Only)</label>
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <a id="friday_sale_banner" data-input="thumbnail3" data-preview="holder13" class="btn btn-primary">
                                        <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                </span>
                                <input id="thumbnail3" class="form-control" name="friday_sale_banner" value="{{$data->friday_sale_banner}}" type="text" >
                            </div>
                            <div id="holder13" style="margin-top:15px;max-height:100px;">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="col-lg-12 col-sm-12 col-12">
                            <div class="form-group">
                                <img src="{{URL::to('')}}/{{$data->promotional1}}" alt="">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <label>New Product Image (Single Image Only)</label>
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <a id="promotional1" data-input="thumbnail33" data-preview="holder133" class="btn btn-primary">
                                        <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                </span>
                                <input id="thumbnail33" class="form-control" name="promotional1" value="{{$data->promotional1}}" type="text" >
                            </div>
                            <div id="holder133" style="margin-top:15px;max-height:100px;">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="col-lg-12 col-sm-12 col-12">
                            <div class="form-group">
                                <img src="{{URL::to('')}}/{{$data->print_on_demand}}" alt="">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <label>Print on demand (Single Image Only)</label>
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <a id="print_on_demand" data-input="thumbnail2333" data-preview="holder1333" class="btn btn-primary">
                                        <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                </span>
                                <input id="thumbnail2333" class="form-control" name="print_on_demand" value="{{$data->print_on_demand}}" type="text" >
                            </div>
                            <div id="holder1333" style="margin-top:15px;max-height:100px;">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="col-lg-12 col-sm-12 col-12">
                            <div class="form-group">
                                <img src="{{URL::to('')}}/{{$data->pre_order_1}}" alt="">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <label>Top selling</label>
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <a id="pre_order_1" data-input="thumbnxcvail2333" data-preview="hozxclder1333" class="btn btn-primary">
                                        <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                </span>
                                <input id="thumbnxcvail2333" class="form-control" name="pre_order_1" value="{{$data->pre_order_1}}" type="text" >
                            </div>
                            <div id="hozxclder1333" style="margin-top:15px;max-height:100px;">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="col-lg-12 col-sm-12 col-12">
                            <div class="form-group">
                                <img src="{{URL::to('')}}/{{$data->pre_order_2}}" alt="">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <label>Marketing Banner 05 (Single Image Only)</label>
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <a id="pre_order_2" data-input="thumbcvbcvail2333" data-preview="hozxcldecvr1333" class="btn btn-primary">
                                        <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                </span>
                                <input id="thumbcvbcvail2333" class="form-control" name="pre_order_2" value="{{$data->pre_order_2}}" type="text" >
                            </div>
                            <div id="hozxcldecvr1333" style="margin-top:15px;max-height:100px;">
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});

</script>
<script>
    (function($) {

$.fn.filemanager = function(type, options) {
    type = type || 'file';

    this.on('click', function(e) {
        var route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
        var target_input = $('#' + $(this).data('input'));
        var target_preview = $('#' + $(this).data('preview'));
        window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
        window.SetUrl = function(items) {
            var file_path = items.map(function(item) {
                return item.url;
            }).join(',');

            var url = '{{url('/')}}';
            var myNewStr = file_path.replace(url, '');
            file_path = myNewStr;
            // set the value of the desired input to image url
            target_input.val('').val(file_path).trigger('change');

            // clear previous preview
            target_preview.html('');

            // set or change the preview image src
            items.forEach(function(item) {
                target_preview.append(
                    $('<img>').css('width', '5rem').attr('src', item.thumb_url)
                );
            });

            // trigger change event
            target_preview.trigger('change');
        };
        return false;
    });
}

})(jQuery);

var route_prefix = "{{ url('')}}/filemanager";
$('#lfm234').filemanager('', {
prefix: route_prefix
});
$('#lfm23412').filemanager('', {
prefix: route_prefix
});
$('#lfm23415').filemanager('', {
prefix: route_prefix
});
$('#friday_sale_banner').filemanager('', {
prefix: route_prefix
});
$('#promotional1').filemanager('', {
prefix: route_prefix
});
$('#print_on_demand').filemanager('', {
prefix: route_prefix
});
$('#pre_order_2').filemanager('', {
prefix: route_prefix
});
$('#pre_order_1').filemanager('', {
prefix: route_prefix
});
</script>

@endpush