@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Create New Brand </h4>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('brand.store')}}" method="POST" enctype="multipart/form-data">
                @CSRF
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Brand Name*</label>
                            <input type="text" name="title" value="{{old('title')}}" required="required">
                            @error('title')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <input type="hidden" name="status" value="active">
                    <input type="hidden" name="is_parent" value="1">
                    <div class="col-lg-6">
                        <label>Icon (Size: 280*280)</label>
                        <div class="input-group">
                            <span class="input-group-btn">
                                <a id="lfm2896734" data-input="thumbnail2454" data-preview="holder45232" class="btn btn-primary">
                                    <i class="fa fa-picture-o"></i> Choose
                                </a>
                            </span>
                            <input id="thumbnail2454" class="form-control" name="icon" value="" type="text" >
                        </div>
                        <div id="holder45232" style="margin-top:15px;max-height:100px;">
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>

<script type="text/javascript">

$(document).ready(function(){
    $('#parent_id').hide();
});
$('#is_parent').on('change', function (e) {
    let yesorno = parseFloat( $(this).find('option:selected').val() ) || 0;
    if(yesorno == 1){
        $('#parent_id').hide();
    }
    else{
        $('#parent_id').show();
    }
});
</script>
<script type="text/javascript">
(function($) {

    $.fn.filemanager = function(type, options) {
        type = type || 'file';

        this.on('click', function(e) {
            var route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
            var target_input = $('#' + $(this).data('input'));
            var target_preview = $('#' + $(this).data('preview'));
            window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
            window.SetUrl = function(items) {
                var file_path = items.map(function(item) {
                    var url = '{{url('/')}}';
                    var myNewStr = item.url.replace(url, '');
                    return myNewStr;
                }).join(',');

                var url = '{{url('/')}}';
                var myNewStr = file_path.replace(url, '');
                file_path = myNewStr;
                // set the value of the desired input to image url
                target_input.val('').val(file_path).trigger('change');

                // clear previous preview
                target_preview.html('');

                // set or change the preview image src
                items.forEach(function(item) {
                    target_preview.append(
                        $('<img>').css('width', '5rem').attr('src', item.thumb_url)
                    );
                });

                // trigger change event
                target_preview.trigger('change');
            };
            return false;
        });
    }

})(jQuery);

var route_prefix = "{{ url('')}}/filemanager";
$('#lfm2896734').filemanager('', {
    prefix: route_prefix
});
$('#lfmcxvb234').filemanager('', {
    prefix: route_prefix
});
</script>
@endpush