@extends('backend.layouts.app')
@section('content')
<div class="content">
   <div class="page-header">
      <div class="page-title">
         <h4>Customer List</h4>
      </div>
   </div>
   <div class="row">
      <div class="col-md-12">
         @include('backend.layouts.notification')
      </div>
   </div>
   <div class="card">
      <div class="card-body">
         <div class="table-top">
            <div class="search-set">
               <div class="search-input">
                  <a class="btn btn-searchset"><img src="{{URL::to('')}}/public/assets/img/icons/search-white.svg" alt="img"></a>
               </div>
            </div>
         </div>
         <div class="table-responsive">
            <table class="table">
               <thead>
                  <tr>
                     <th>SN</th>
                     <th>Name</th>
                     <th>Phone</th>
                     <th>Address</th>
                     <th>Address</th>
                  </tr>
               </thead>
               <tbody>
                  @forelse($customers as $customer)
                  <tr>
                     <td>{{ $loop->index + 1 }}</td>
                     <td>{{ $customer->name }}</td>
                     <td>{{ $customer->phone }}</td>
                     <td>
                        @if ($customer->latest_order_address)
                        {{ $customer->latest_order_address }}
                        @else
                        N/A
                        @endif
                     </td>
                     <td>
                        @if ($customer->latest_order_ip)
                        {{ $customer->latest_order_ip }}
                        @else
                        N/A
                        @endif
                     </td>
                  </tr>
                  @empty
                  <tr>
                     <td colspan="5" class="text-center">No customers found</td>
                  </tr>
                  @endforelse
               </tbody>
            </table>
            <br>
            <nav aria-label="Page navigation example">
               {{ $customers->links("pagination::bootstrap-4") }}
            </nav>
         </div>
      </div>
   </div>
</div>
@endsection