@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Delivery Partner  Add</h4>
            <h6>Create new Delivery Partner</h6>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('delivery.store')}}" method="POST" enctype="multipart/form-data">
                @CSRF
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Delivery Partner Name*</label>
                            <input type="text" name="name" value="{{old('name')}}" required="required">
                            @error('name')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6">
                            <label>Delivery Partner Logo (Single Image Only)</label>
                            <div class="input-group">
                                <span class="input-group-btn">
                                    <a id="lfm23412" data-input="thumbnail1" data-preview="holder1" class="btn btn-primary">
                                        <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                </span>
                                <input id="thumbnail1" class="form-control" name="photo" value="" type="text" >
                            </div>
                            <div id="holder1" style="margin-top:15px;max-height:100px;">
                            </div>
                        </div>

                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>
<script>
    (function($) {

$.fn.filemanager = function(type, options) {
    type = type || 'file';

    this.on('click', function(e) {
        var route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
        var target_input = $('#' + $(this).data('input'));
        var target_preview = $('#' + $(this).data('preview'));
        window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
        window.SetUrl = function(items) {
            var file_path = items.map(function(item) {
                return item.url;
            }).join(',');

            var url = '{{url('/')}}';
            var myNewStr = file_path.replace(url, '');
            file_path = myNewStr;
            // set the value of the desired input to image url
            target_input.val('').val(file_path).trigger('change');

            // clear previous preview
            target_preview.html('');

            // set or change the preview image src
            items.forEach(function(item) {
                target_preview.append(
                    $('<img>').css('width', '5rem').attr('src', item.thumb_url)
                );
            });

            // trigger change event
            target_preview.trigger('change');
        };
        return false;
    });
}

})(jQuery);

var route_prefix = "{{ url('')}}/filemanager";
$('#lfm234').filemanager('', {
prefix: route_prefix
});
$('#lfm23412').filemanager('', {
prefix: route_prefix
});
</script>

@endpush