@extends('backend.layouts.app')

@section('content')
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Product List</h4>
        </div>
        
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <div class="table-top">
                <div class="search-set">
                    <div class="search-input">
                        <a class="btn btn-searchset"><img src="{{URL::to('')}}/public/assets/img/icons/search-white.svg" alt="img"></a>
                    </div>
                </div>
                <a href="{{route('product.create')}}" class="btn btn-submit">Add Product</a>
            </div>
            <div class="table-responsive">
                <table class="table ns">
                    <thead>
                        <tr>
                            <th  class="noExport">Action</th>
                            <th>Product</th>
                            <th>Category </th>
                            <th>Price</th>
                            <th>Sale price</th>
                            <th>Stock</th>
                            
                        </tr>
                    </thead>
                    <tbody>
                    @if(count($products)>0)
                        @foreach($products as $product)  
              
                        <tr>
                            <td>
                                <a href="{{route('product.view',$product->slug)}}" target="_blank" >
                                   <img src="{{URL::to('')}}/public/assets/view.svg"style="max-width: 25px;">
                                </a>
                                <br>
                                <a href="{{route('product.edit',$product->id)}}">
                                     <img src="{{URL::to('')}}/public/assets/edit.svg"style="max-width: 25px;">
                                </a>
                                <br>
                                <a data-bs-target="#createpayment{{$loop->index}}" data-bs-toggle="modal">
                                   <img src="{{URL::to('')}}/public/assets/delete.svg"style="max-width: 25px;">
                                </a>
                                <div class="modal fade" id="createpayment{{$loop->index}}" tabindex="-1" aria-labelledby="createpayment" aria-hidden="true">
                                    <div class="modal-dialog modal-md modal-dialog-centered">
                                        <div class="modal-content">
                                       
                                            <div class="modal-header">
                                                <h5 class="modal-title text-center">Are you sure?</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <div class="modal-footer text-center" style="justify-content: center;">
                                                <form method="POST" id="delete-form{{$product->id}}" action="{{route('product.destroy',[$product->id])}}">
                                                @csrf 
                                                @method('delete')
                                                <button type="submit" class="btn btn-submit">Confirm Delete</button>
                                                </form>
                                                <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">Close</button>
                                            </div>
                                        
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <a href="javascript:void(0);" class="product-img">
                                    <img src="{{URL::to('')}}/{{$product->photo}}" alt="product">
                                </a>
                                <a href="javascript:void(0);">{{substr($product->title,0,25)}}...</a>
                            </td>
                            <td>
                            @php 
                              $category=explode(',',$product->cat_id);
                              $childcategory=explode(',',$product->child_cat_id);
                            @endphp
                            @if($category)
                            @foreach($category as $row)
                            @php 
                            $category_info=DB::table('categories')->where('id',$row)->first();
                            @endphp
                            @if($category_info)
                            {{$category_info->title}},
                            @endif
                            @endforeach 
                            @endif
                            @if($childcategory)
                            @foreach($childcategory as $chilrow)
                            @php 
                            $child_category_info=DB::table('categories')->where('id',$chilrow)->first();
                            @endphp
                            @if($child_category_info)
                                {{$child_category_info->title}},
                            @endif
                            @endforeach    
                            @endif
                            </td>

                            <td>{{ $product->price}}</td>
                            <td>{{ $product->offer_price}}</td>
                            <td>
                                Product-{{ $product->stock}}<br>
                                @foreach($size_data[$product->id] as $size)
        {{ $size->size->name }}-{{ $size->stock }}
    @endforeach

    <br>
    @foreach($liquid_data[$product->id] as $liquid)
        {{ $liquid->liquid->name }}-{{ $liquid->stock }}
    @endforeach
                            </td>
                            
                        </tr>
                        @endforeach
                        @else
                        @endif
                    </tbody>
                    
                </table>
            
            </div>
        </div>
    </div>

</div>
@endsection
@push('styles')

@endpush


@push('scripts')

@endpush