<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-GLhlTQ8iRABdZLl6O3oVMWSktQOp6b7In1Zl3/Jr59b6EGGoI1aFkw7cmDA6j6gD" crossorigin="anonymous">
    <style>
    .repos{
        border: 1px solid #d5d1d1;
    padding: 15px;
    margin-bottom: -1px;
    margin-right: -1px;
    }
</style>
<style>
table {
  border-collapse: collapse;
  width: 100%;
}

td, th {
  border: 1px solid #dddddd;
  text-align: left;
  padding: 8px;
}

</style>
</head>
<body>
<div class="content">
    <div class="card" id="printarea">
        <div class="card-body">
            <div class="text-center" style="border-bottom:1px solid black;">
                <h2>{{$settings->website}}</h2>
                <div>Address: {{$settings->website}}</div>
                <div>Phone: {{$settings->phone}}</div>
                <div>Email: {{$settings->email}}</div><br>
            </div>
            <div class="text-center">
                <br>
                <h2>Full Sales Report</h2>
                <p>Report Generate Date : {{$todate}}</p>
                <br><br>
            </div>
            <div class="table-responsive">
                <table class="table">  
                    <tr>
                        <th colspan="2" class="text-center">Order</th>
                    </tr>
                    <tr>
                        <td>Total Order</td>
                        <td >{{$total_order}}</td>
                    </tr>
                    <tr>
                        <td>Total Order Pending</td>
                        <td>{{$total_pending}}</td>
                    </tr>
                    <tr>
                        <td>Total Order Delivery Done</td>
                        <td>{{$total_deliver}}</td>
                    </tr>
                    <tr>
                        <td>Total Order Cancel</td>
                        <td>{{$total_cancel}}</td>
                    </tr>
                    <tr>
                        <th colspan="2" class="text-center">Product</th>
                    </tr>
                    <tr>
                        <td>Total Product in Sale</td>
                        <td>{{$productinsale}}</td>
                    </tr>
                    <tr>
                        <td>Total Product Pending</td>
                        <td>{{$productsale}}</td>
                    </tr>
                    <tr>
                        <td>Total Product Delivery</td>
                        <td>{{$productdelivery}}</td>
                    </tr>
                    <tr>
                        <td>Total Product Cancel</td>
                        <td>{{$productCancel}}</td>
                    </tr>
                    <tr>
                        <th colspan="2" class="text-center">Sales Delivered</th>
                    </tr>
                    <tr>
                        <td>Total Product Cost Price</td>
                        <td>{{$costprice}}</td>
                    </tr>
                    <tr>
                        <td>Total Product Price</td>
                        <td>{{$totalprice}}</td>
                    </tr>
                    <tr>
                        <td>Total Gross Profit</td>
                        <td>{{$grossprofit}}</td>
                    </tr>
                    <tr>
                        <td>Total Discount</td>
                        <td>{{$totaldiscount}}</td>
                    </tr>
                    <tr>
                        <td>Total Cancel Cost</td>
                        <td>{{$totalloss}}</td>
                    </tr>
                    <tr>
                        <td>Total Gross Sale</td>
                        <td>{{$grosssale}}</td>
                    </tr>
                    <tr>
                        <td>Total Expanse</td>
                        <td>{{$totalexpanse}}</td>
                    </tr>
                    <tr>
                        <td>Net Profit</td>
                        <td>{{$netprofit}}</td>
                    </tr>
                </table>
            </div>
           
        </div>
    </div>
    <div class="card"><br><br>
        <div class="card-body">
            <div class="text-center">
               <div class="text-center">
                    <h2>Full Product Report</h2>
                    <p>Report Generate Date : {{$fromDate}}</p>
                </div><br><br>
            </div>
            <div class="table-responsive">
                <table class="table ">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Product Name</th>
                            <th>SKU</th>
                            <th>Size</th>
                            <th>Color</th>
                            <th>Quantity</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if(isset($data))
                        @foreach($data as $product)   
                        <tr>
                            <td>{{$loop->index+1}}</td>
                            <td>{{$product['product_name']}}</td>
                            <td>{{$product['sku']}}</td>
                            <td>{{$product['size']}}</td>
                            <td>{{$product['color']}}</td>
                            <td>{{$product['quantity']}}</td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="6" class="text-center">No order found!!!</td>
                        </tr>
                        @endif
                    </tbody>
                    
                </table>
            
            </div>
        </div>
    </div>

</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js" integrity="sha384-w76AqPfDkMBDXo30jS1Sgez6pr3x5MlQ1ZAGC+nuZB+EYdgRZgiwxhTBTkF7CXvN" crossorigin="anonymous"></script>
  </body>
</html>