@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <title>Invoice</title>
      <style>
         .clearfix:after {
         content: "";
         display: table;
         clear: both;
         }
         a {
         color: #5D6975;
         text-decoration: underline;
         }
         body {
         position: relative;
         width: 18cm;
         height: auto;
         margin: 0 auto;
         color: #001028;
         background: #FFFFFF;
         font-family: Arial, sans-serif;
         font-size: 12px;
         font-family: Arial;
         }
         header {
         padding: 10px 0;
         margin-bottom: 30px;
         }
         #logo {
         text-align: center;
         margin-bottom: 10px;
         }
         #logo img {
         width: 90px;
         }
         h2 {
         border-top: 1px solid #000;
         border-bottom: 1px solid #000;
         color: #4a5056;
         font-size: 20px;
         line-height: 1.4em;
         font-weight: 500;
         text-align: center;
         margin: 0 0 20px 0;
         }
         #project {
         float: left;
         }
         address {
         font-style: normal;
         }
         #project span {
         color: #5D6975;
         text-align: right;
         width: 52px;
         margin-right: 10px;
         display: inline-block;
         font-size: 0.8em;
         }
         #company {
         float: right;
         text-align: right;
         }
         #project div,
         #company div {
         white-space: nowrap;
         }
         table {
         width: 100%;
         border-collapse: collapse;
         margin-bottom: 20px;
         }
         table th, table td {
         border: 1px solid #ddd;
         padding: 8px;
         text-align: left;
         }
         table th {
         background-color: #f2f2f2;
         color: #333;
         }
         table td {
         background-color: #fff;
         }
         .text-right {
         text-align: right;
         }
         .text-center {
         text-align: center;
         }
         .thick-line {
         border-top: 2px solid #5D6975;
         }
         .no-line {
         border: none;
         }
         .grand {
         font-weight: bold;
         }
         .productimgname img{
         margin-right: 10px;
         }
         .product-img{
         min-width: 40px;
         width: 40px;
         height: 40px;
         border: 0;
         }
         img {
         max-width: 100%;
         height: auto;
         }
         #notices .notice {
         color: #5D6975;
         font-size: 1.2em;
         }
         footer {
         color: #5D6975;
         width: 100%;
         height: 30px;
         position: absolute;
         bottom: 0;
         border-top: 1px solid #C1CED9;
         padding: 8px 0;
         text-align: center;
         }
      </style>
   </head>
   <body>
      @foreach($invoices as $invoice)
      <header class="clearfix">
         <div id="logo">
            <img src="{{ URL::to('') }}/{{ $settings->logo }}" style="width:150px;">
         </div>
         <h2>INVOICE #{{ $invoice['order']->order_number }}</h2>
         <div id="company" class="clearfix">
            <address>
               <strong>Billed By:</strong><br>
               {{ $settings->website }}<br>
               Address: {!! $settings->address !!}<br>
               Phone: {{ $settings->phone }}
            </address>
         </div>
         <div id="project">
            <address>
               <strong>Billed To:</strong><br>
               Name: {{ $invoice['order']->first_name }}<br>
               Address: {{ $invoice['order']->address }} <br>
               Phone: {{ $invoice['order']->phone }}
            </address>
         </div>
      </header>
      <header>
         <div id="company" class="clearfix">
            <address>
               <strong>Order id:</strong><br>
               {{ $invoice['order']->id }}
            </address>
         </div>
         <div id="project">
            <address>
               <strong>Order Date:</strong><br>
               {{ $invoice['order']->created_at->format('d-M-Y h:i A') }}
            </address>
         </div>
      </header>
      <main>
         <table>
            <thead>
               <tr>
                  <td class="service"><strong>Item</strong></td>
                  <td class="text-center"><strong>Quantity</strong></td>
                  <td class="text-center"><strong>Price</strong></td>
                  <td class="text-right"><strong>Total</strong></td>
               </tr>
            </thead>
            <tbody>
               @foreach($invoice['products'] as $product)
               <tr>
                  <td class="service">
                     <div style="display: flex; align-items: center;">
                        {{ $loop->iteration }}. 
                       <div class="product-img">
    @if(!empty($product['product']->product_photo))
        <img src="{{ URL::to('/') }}/{{ $product['product']->product_photo }}" alt="Product Image">
    @else
        <p>No image available</p>
    @endif
</div>
@if(!empty($product['product']->product_title))
                        <span style="margin-left: 10px;"> {{ $product['product']->product_title }}</span>
                        @endif
                     </div>
                     <br>
                     @if($product['product']->color) Color: {{ $product['product']->color }} @endif <br>
                     @if($product['product']->size) Size: {{ $product['product']->size }} @endif <br>
                     @if($product['product']->liquid) Liquid: {{ $product['product']->liquid }} @endif
                  </td>
                  <td class="text-center">{{ $product['detail']->quantity }}</td>
                  <td class="text-center">
                     @if($product['product']->size)
                     @if(!empty($product['product_size_id']->price))
                     Tk {{ $product['product_size_id']->price }}
                     @endif
                     @else
                     Tk {{ $product['detail']->price }}
                     @endif
                  </td>
                  <td class="text-right">
                     @if($product['product']->size)
                     @php
                     $total = $product['product_size_id']->price * $product['detail']->quantity;
                     @endphp
                     Tk {{ $total }}
                     @else
                     Tk {{ $product['detail']->price }}
                     @endif
                  </td>
               </tr>
               @endforeach
               <tr>
                  <td colspan="3" class="grand text-right">Subtotal</td>
                  <td class="grand text-right">Tk {{ $invoice['order']->sub_total }}</td>
               </tr>
               <tr>
                  <td colspan="3" class="grand text-right">Shipping</td>
                  <td class="grand text-right">Tk {{ $invoice['order']->shipping_cost }}</td>
               </tr>
               <tr>
                  <td colspan="3" class="grand text-right">Discount</td>
                  <td class="grand text-right">Tk {{ $invoice['order']->discount }}</td>
               </tr>
               <tr>
                  <td colspan="3" class="grand text-right">TOTAL</td>
                  <td class="grand text-right">Tk {{ $invoice['order']->total_amount }}</td>
               </tr>
               <tr>
                  <td colspan="3" class="grand text-right">PAID</td>
                  <td class="grand text-right">Tk {{ $invoice['order']->payment }}</td>
               </tr>
               <tr>
                  <td colspan="3" class="grand text-right">DUE</td>
                  <td class="grand text-right">Tk {{ $invoice['order']->total_amount - $invoice['order']->payment }}</td>
               </tr>
            </tbody>
         </table>
      </main>
      <footer>
         Invoice was created on a computer and is valid without the signature and seal.
      </footer>
      <div style="page-break-after: always;"></div>
      @endforeach
   </body>
</html>