@extends('backend.layouts.app')

@section('content')
    @php
        $generalSettings = App\Models\Setting::find(1); // Fetching general settings
    @endphp

    <div class="content">
        <div class="page-header">
            <div class="page-title">
                <h4>Order Add</h4>
                <h6>Create New Order</h6>
            </div>
        </div>

        <form action="{{ route('order.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12 col-sm-12 col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Customer Info</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <label>Customer Name</label>
                                        <input type="text" name="customerName" value="{{ old('customerName') }}" required>
                                        @error('customerName')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <label>Customer Phone</label>
                                        <input type="text" name="customerPhone" value="{{ old('customerPhone') }}" required>
                                        @error('customerPhone')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-sm-12 col-12">
                                    <div class="form-group">
                                        <label>Customer Address</label>
                                        <textarea name="customerAddress" rows="3">{{ old('customerAddress') }}</textarea>
                                        @error('customerAddress')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-sm-12 col-12">
                                    <div class="form-group">
                                        <label>Customer Note</label>
                                        <textarea name="customerNote" rows="2">{{ old('customerNote') }}</textarea>
                                        @error('customerNote')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 col-sm-12 col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Product Info</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-12 col-sm-12 col-12">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Action</th>
                                                <th>ID</th>
                                                <th>Product Name</th>
                                                <th>Color</th>
                                                <th>Size</th>
                                                <th>Quantity</th>
                                                <th>Price</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody class="productable">
                                            <!-- Product rows will be added dynamically -->
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-lg-12 col-sm-12 col-12">
    <div class="form-group">
        <label>Select Product</label>
        <select name="productselect" class="form-control productsc" id="productselect">
            <option value="">Select a Product</option>
            @foreach ($products as $product)
                @php
                    $sizeVariations = $product->sizeVariations;
                    $sizes = $sizeVariations->map(function ($variation) {
                        return ['name' => $variation->size->name, 'price' => $variation->price];
                    });
                @endphp
                <option value="{{ $product->id }}"
                        data-stock="{{ $product->stock }}"
                        data-title="{{ $product->title }}"
                        data-price="{{ $product->offer_price }}"
                        data-color="{{ $product->color }}"
                        data-sizes="{{ json_encode($sizes) }}"
                        data-photo="{{ $product->photo }}">
                    <img src="{{ URL::to($product->photo) }}" alt="{{ $product->title }}" style="width: 50px; height: auto;"> {{ $product->title }}
                </option>
            @endforeach
        </select>
    </div>
</div>

                                <!-- Additional fields for subtotals, shipping, discounts, payment, and total -->
                                <div class="col-lg-12 col-sm-12 col-12 row">
                                    <br>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Sub Total</label>
                                       <input type="text" class="form-control" value="0" readonly name="sub_total" id="sub_total" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Delivery</label>
                                       <input type="text" class="form-control" value="0" name="shipping_cost" id="shipping_cost" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Discount</label>
                                       <input type="text" class="form-control" value="0" name="discount" id="discount" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Payment</label>
                                       <input type="text" class="form-control" value="0" name="payment" id="payment" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Due</label>
                                       <input type="text" class="form-control" value="0" readonly name="collectables" id="collectables" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Total</label>
                                       <input type="text" class="form-control" value="0" readonly name="total_amount" id="total_amount" style="width: 200px; margin-left: 20px;">
                                    </div>
                                 </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </div>
        </form>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('.productsc').select2(); // Initialize select2 plugin

            $('#shipping_cost, #discount, #payment').on('input', function() {
                calculateTotal();
            });
        });

        let productCount = 0; 

        $('#productselect').on('change', function() {
            const selectedProduct = $(this).find('option:selected');
            const productId = selectedProduct.val();
            const productTitle = selectedProduct.data('title');
            const productColor = selectedProduct.data('color');
            const productSizes = selectedProduct.data('sizes');
            const productPrice = selectedProduct.data('price');
            const productStock = selectedProduct.data('stock');
            const productPhoto = selectedProduct.data('photo');

            productCount++;

            //const colors = productColor.split(',').map(color => `<option value="${color.trim()}">${color.trim()}</option>`).join('');
            // Generate options for color select
            const colors = productColor.split(',').filter((_, index) => index % 2 === 0).map(color => `<option value="${color.trim()}">${color.trim()}</option>`).join('');

            const sizes = productSizes.map(size => `<option value="${size.name}" data-price="${size.price}">${size.name}</option>`).join('');

            const newRow = `
                <tr>
                   <td><button class="btn btn-outline-primary remove-row" type="button">X</button></td>
                    <td>${productCount}<input type="hidden" name="order[${productCount}][product_id]" value="${productId}"></td>
                    <td><img src="{{URL::to('')}}${productPhoto}" alt="product" style="width: 50px; height: auto;"> ${productTitle.substring(0, 25)}..</td>
                    <td><select name="order[${productCount}][color]" class="form-control">${colors}</select></td>
                    <td><select name="order[${productCount}][size]" class="form-control size-select">${sizes}</select></td>
                    <td><input type="number" class="form-control quantity" name="order[${productCount}][quantity]" data-id="${productId}" value="1" style="width: 80px;"></td>
                    <td><span class="price">${productPrice}</span><input type="hidden" name="order[${productCount}][price]" value="${productPrice}" class="price-input" id="price${productId}"></td>
                    <td><p class="subtotal" id="subtotal${productId}">${productPrice}</p></td>
                    
                </tr>
            `;

            $('.productable').append(newRow);

            calculateTotal();

            $('.size-select').on('change', function() {
                const selectedSize = $(this).find('option:selected');
                const newPrice = selectedSize.data('price');
                const row = $(this).closest('tr');
                row.find('.price').text(newPrice);
                row.find('.price-input').val(newPrice);
                updateSubtotal(row.find('.quantity'));
            });

            $('.quantity').on('change', function() {
                updateSubtotal($(this));
            });

            $('.remove-row').on('click', function() {
                $(this).closest('tr').remove();
                calculateTotal();
            });
        });

        function updateSubtotal(element) {
            const quantity = element.val();
            const row = element.closest('tr');
            const price = row.find('.price-input').val();
            const subtotal = quantity * price;
            row.find('.subtotal').text(subtotal);
            calculateTotal();
        }

        function calculateTotal() {
            let total = 0;
            $('.subtotal').each(function() {
                total += parseFloat($(this).text());
            });
            $('#sub_total').val(total);

            const shippingCost = parseFloat($('#shipping_cost').val() || 0);
            const discount = parseFloat($('#discount').val() || 0);
            const payment = parseFloat($('#payment').val() || 0);

            const finalTotal = total + shippingCost - discount;
            $('#total_amount').val(finalTotal);

            const due = finalTotal - payment;
            $('#collectables').val(due);
        }
    </script>
@endpush
