@extends('backend.layouts.app')

@section('content')
    @php
        $generalSettings = App\Models\Setting::find(1); // Fetching general settings
        $stat           = App\Models\StatusControl::get();
    @endphp

    <div class="content">
        <div class="page-header">
            <div class="page-title">
                <h4>Update Order Details</h4>
            </div>
        </div>

        <form action="{{ route('order.update', $order->id) }}" method="POST" enctype="multipart/form-data">
            @CSRF
      @csrf 
      @method('PATCH')
      @if ($errors->any())
      <div class="alert alert-danger">
         <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
         </ul>
      </div>
      @endif

            <div class="row">
                <div class="col-lg-12 col-sm-12 col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Customer Info</h4>
                        </div>
                        <div class="card-body">
                           <div class="row">
            <div class="col-lg-4 col-sm-6 col-12">
   <div class="form-group">
       <label for="assign_user_id">Status</label>
      <select name="status" class="form-control">
    @foreach($stat as $statusOption)
        <option value="{{ $statusOption->name }}" {{ $order->status == $statusOption->name ? 'selected' : '' }}>
            {{ $statusOption->name }}
        </option>
    @endforeach
</select>

   </div>
</div>

            <div class="col-lg-4 col-sm-6 col-12">
   @if($user->is_featured != null)
   <div class="form-group">
      <label for="assign_user_id">Assign user</label>
      <select id="assign_user_id" class="form-control" name="assign_user_id" required>
         <option value="">Choose user</option>
         @foreach ($results as $datauser)
         <option value="{{ $datauser->id }}" {{ $datauser->id == $order->assign_user_id ? 'selected' : '' }}>{{ $datauser->name }}</option>
         @endforeach
      </select>
   </div>
   @endif
</div>

                <div class="col-lg-4 col-sm-6 col-12">
   <div class="form-group">
      <label>Payment Status</label>
      <select class="select" name="payment_status">
         <option value="unpaid" @if($order->payment_status == 'unpaid') selected @endif>Unpaid</option>
         <option value="paid" @if($order->payment_status == 'paid') selected @endif>Paid</option>
         <option value="Partial Payment" @if($order->payment_status == 'Partial Payment') selected @endif>Partial Payment</option>
      </select>
   </div>
</div>

         </div>
                            <div class="row">
                                <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                           <label>Customer Name</label>
                           <input type="text" name="customerName" value="{{$order->first_name}}" required="required">
                           @error('customerName')
                           <span class="text-danger">{{$message}}</span>
                           @enderror
                        </div>
                     </div>
                     <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                           <label>Customer Phone</label>
                           <input type="number" name="customerPhone" value="{{$order->phone}}" required="required">
                           @error('customerPhone')
                           <span class="text-danger">{{$message}}</span>
                           @enderror
                        </div>
                     </div>
                     <div class="col-lg-4 col-sm-12 col-12">
                        <label  class="form-label">Courier Tracking ID</label>
                        <input type="text" class="form-control" value="{{ $order->courier_tracking_id}}" name="courier_tracking_id" />
                     </div>
                     <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                           <label>Customer Address</label>
                           <textarea name="customerAddress" id="" cols="30" rows="10">{!!$order->address!!}</textarea>
                           @error('customerAddress')
                           <span class="text-danger">{{$message}}</span>
                           @enderror
                        </div>
                     </div>
                     <div class="col-lg-12 row mt-2 mb-2">
                        <div class="col-md-3">
                           <label  class="form-label"> Courier  </label>
                           <select class="form-control" name="courier_id">
                              <option value="" data-charge="0">Select One</option>
                              @foreach($couriers as $courier)
                              <option value="{{ $courier->id }}" {{ $courier->id==$order->courier_id ? 'selected' : '' }}> {{ $courier->name }} </option>
                              @endforeach
                           </select>
                        </div>
                        <div class="row for_redx {{ $order->courier_id != 1 ? 'd-none' : '' }}">
                           <h5 class="text-danger mt-3">Redx Courier Service</h5>
                           <div class="col-md-3">
                              <label  class="form-label">Choose Area</label>
                              <select class="form-control select2" id="area_select">
                                 <option value="">Select One</option>
                                 @foreach($areas as $key=>$area)
                                 <option value="{{ $area['id'] }}" {{ $order->area_id ==  $area['id'] ? 'selected' : '' }}>{{ $area['name'] }}</option>
                                 @endforeach
                              </select>
                           </div>
                           <div class="col-md-3">
                              <label  class="form-label">Area ID</label>
                              <input type="text" readonly class="form-control" id="area_id" name="redx_area_id" value="{{ $order->redx_area_id}}"/>
                           </div>
                           <div class="col-md-3">
                              <label  class="form-label">Area Name</label>
                              <input type="text" readonly class="form-control" id="area_name" name="area_name" value="{{ $order->redx_area}}"/>
                           </div>
                        </div>
                        <div class="row for_pathao {{ $order->courier_id != 2 ? 'd-none' : '' }}">
                           <h5 class="text-danger mt-3">Pathao Courier Service</h5>
                           <div class="col-md-3">
                              <label  class="form-label">Choose store</label>
                              <select class="form-control select2" id="store_select" name="store_id">
                                 <option value="">Select One</option>
                                 @foreach($stores as $store)
                                 <option value="{{ $store['store_id'] }}">{{ $store['store_name'] }}</option>
                                 @endforeach
                              </select>
                           </div>
                           <div class="col-md-3">
                              <label  class="form-label">Choose City</label>
                              <select class="form-control select2" id="city_select" name="pathao_city">
                                 <option value="">Select One</option>
                                 @foreach($cities as $key=>$city)
                                 <option value="{{ $city['city_id'] }}" {{ $order->city ==  $city['city_id'] ? 'selected' : '' }}>{{ $city['city_name'] }}</option>
                                 @endforeach
                              </select>
                           </div>
                           <div class="col-md-3">
                              <label  class="form-label">Choose Zone</label>
                              <select class="form-control select2" id="zone_select" name="pathao_state">
                                 <option value="{{ $order->state }}">Select One</option>
                              </select>
                           </div>
                           <div class="col-md-3">
                              <label  class="form-label">Choose Area</label>
                              <select class="form-control select2" id="pathao_area_id" name="pathao_area_id">
                                 <option value="{{ $order->pathao_area_id }}">Select One</option>
                              </select>
                           </div>
                           <input type="hidden" name="weight" value="0.5">
                           
                        </div>
                     </div>
                     <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                           <label>Customer Note</label>
                           <textarea name="customerNote" id="" cols="30" rows="10">{!!$order->note!!}</textarea>
                           @error('customerNote')
                           <span class="text-danger">{{$message}}</span>
                           @enderror
                        </div>
                     </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 col-sm-12 col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Product Info</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-12 col-sm-12 col-12">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Action</th>
                                                <th>ID</th>
                                                <th>Product Name</th>
                                                <th>Color</th>
                                                <th>Size</th>
                                                <th>Quantity</th>
                                                <th>Price</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody class="productable">
                                            @foreach($order->orderDetails as $detail)
                                                @php
                                                    $product = $detail->product;
                                                    $sizeVariations = $product->sizeVariations;
                                                    $sizes = $sizeVariations->map(function ($variation) {
                                                        return ['name' => $variation->size->name, 'price' => $variation->price];
                                                    });
                                                @endphp
                                                <tr>
                                                    <td>
                                                      <button class="btn btn-outline-primary remove-row" type="button">X</button>
                                                   </td>
                                                    <td>
                                                      {{ $loop->iteration }} 
                                                      <input value="{{ $product->id }}" name="order[{{ $loop->iteration }}][product_id]" hidden="hidden">
                                                    </td>
                                                    <td>
                                                      <img src="{{ URL::to($product->photo) }}" alt="product" style="width: 50px; height: auto;"> {{ substr($product->title, 0, 25) }}..
                                                   </td>
                                                    <td>
                                             @php
                                             $string = str_replace('"', '', $product->color);
                                             $color = explode(',', rtrim($string, ','));
                                             @endphp
                                             <select name="order[{{ $loop->index }}][color]" class="form-control">
                                             @foreach($color as $key => $value)
                                             @if($key % 2 == 0)
                                             <option value="{{ $value }}" @if($detail->color == $value) selected @endif>{{ $value }}</option>
                                             @endif
                                             @endforeach
                                             </select>
                                          </td>
                                                    <td>
                                                        <select name="order[{{ $loop->iteration }}][size]" class="form-control size-select">
                                                            @foreach($sizes as $size)
                                                                <option value="{{ $size['name'] }}" data-price="{{ $size['price'] }}" @if($detail->size == $size['name']) selected @endif>{{ $size['name'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td>
                                                      <input type="number" class="form-control quantity" name="order[{{ $loop->iteration }}][quantity]" data-id="{{ $product->id }}" value="{{ $detail->quantity }}" style="width: 80px;">
                                                   </td>
                                                    <td>
                                                      <span class="price">{{ $detail->price }}</span>
                                                      <input type="hidden" name="order[{{ $loop->iteration }}][price]" value="{{ $detail->price }}" class="price-input" id="price{{ $product->id }}">
                                                   </td>
                                                    <td>
                                                      <p class="subtotal" id="subtotal{{ $product->id }}">{{ $detail->quantity * $detail->price }}</p>
                                                   </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-lg-12 col-sm-12 col-12">
                                    <div class="form-group">
                                        <label>Select Product</label>
                                        <select name="productselect" class="form-control productsc" id="productselect">
                                            <option value="">Select a Product</option>
                                            @foreach ($products as $product)
                                                @php
                                                    $sizeVariations = $product->sizeVariations;
                                                    $sizes = $sizeVariations->map(function ($variation) {
                                                        return ['name' => $variation->size->name, 'price' => $variation->price];
                                                    });
                                                @endphp
                                                <option value="{{ $product->id }}"
                                                        data-stock="{{ $product->stock }}"
                                                        data-title="{{ $product->title }}"
                                                        data-price="{{ $product->offer_price }}"
                                                        data-color="{{ $product->color }}"
                                                        data-sizes="{{ json_encode($sizes) }}"
                                                        data-photo="{{ $product->photo }}">
                                                    <img src="{{ URL::to($product->photo) }}" alt="{{ $product->title }}" style="width: 50px; height: auto;"> {{ $product->title }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <!-- Additional fields for subtotals, shipping, discounts, payment, and total -->
                                <div class="col-lg-12 col-sm-12 col-12 row">
                                    <br>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Sub Total</label>
                                       <input type="text" class="form-control" value="{{ $order->sub_total }}" readonly name="sub_total" id="sub_total" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Delivery</label>
                                       <input type="text" class="form-control" value="{{ $order->shipping_cost }}" name="shipping_cost" id="shipping_cost" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Discount</label>
                                       <input type="text" class="form-control" value="{{ $order->discount }}" name="discount" id="discount" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Payment</label>
                                       <input type="text" class="form-control" value="{{ $order->payment }}" name="payment" id="payment" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Due</label>
                                       <input type="text" class="form-control" value="{{ $order->collectables }}" readonly name="collectables" id="collectables" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Total</label>
                                       <input type="text" class="form-control" value="{{ $order->total_amount }}" readonly name="total_amount" id="total_amount" style="width: 200px; margin-left: 20px;">
                                    </div>
                                 </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </div>
        </form>
    </div>
@endsection
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
@endpush
@push('scripts')
<script>
   $(document).on('change', 'select[name="courier_id"]', function(e){
      let courier_id = $(this).val();
      if(courier_id == 1)
       {
            $(document).find('div.for_redx').removeClass('d-none');
            $(document).find('div.for_pathao').addClass('d-none');
       }       
      
      else if(courier_id == 2)
       {
            $(document).find('div.for_pathao').removeClass('d-none');
            $(document).find('div.for_redx').addClass('d-none');
       }
   
      else {
           $(document).find('div.for_pathao').addClass('d-none');
            $(document).find('div.for_redx').addClass('d-none');
       }
   });
   $(document).on('change', '#city_select', function(e){
   
   let city = $(this).val();
   var url = "{{ route('zonesByCity', ":city") }}";
   url = url.replace(':city', city);
   $.ajax({
       url,
       type: 'GET',
       dataType: "json",
       success: function(res){
         if(res.success)
         {
           let html = "<option value=''>Select One</option>";
           for(let i = 0; i < res.zones.length; i++)
           {
              html += "<option value='"+res.zones[i].zone_id+"' >"+res.zones[i].zone_name+"</option>";
           }
           
           $('#zone_select').html(html);
           
         }
       }
     
   });
   
   });
   
   $(document).on('change', '#zone_select', function(e){
     
   let zone = $(this).val();
   var url = "{{ route('areasByZone', ":zone") }}";
   url = url.replace(':zone', zone);
   $.ajax({
       url,
       type: 'GET',
       dataType: "json",
       success: function(res){
         if(res.success)
         {
           let html = "<option value=''>Select One</option>";
           for(let j = 0; j < res.areas.length; j++)
           {
              html += "<option value='"+res.areas[j].area_id+"' >"+res.areas[j].area_name+"</option>";
           }
           
           $('select[name="pathao_area_id"]').html(html);
           
         }
       }
     
   });
   
   });
   
</script>
<script>
   // Assuming jQuery is included in your project
   
   $(document).ready(function() {
   // Event listener for change in the dropdown selection
   $('#area_select').on('change', function() {
       // Get the selected option value
       var selectedAreaId = $(this).val();
       
       // Find the selected option element
       var selectedOption = $(this).find('option:selected');
       
       // Get the area name from the selected option
       var selectedAreaName = selectedOption.text();
       
       // Update the area ID input field with the selected area ID
       $('#area_id').val(selectedAreaId);
       
       // Update the area name input field with the selected area name
       $('#area_name').val(selectedAreaName);
   });
   });
   
   
</script>
<script>
    $(document).ready(function() {
        $('.productsc').select2(); // Initialize select2 plugin

        $('#shipping_cost, #discount, #payment').on('input', function() {
            calculateTotal();
        });
        
        // Retrieve initial product count from existing order details
        let productCount = {{ $order->orderDetails->count() }};
        
        $('#productselect').on('change', function() {
            const selectedProduct = $(this).find('option:selected');
            const productId = selectedProduct.val();
            const productTitle = selectedProduct.data('title');
            const productColor = selectedProduct.data('color');
            const productSizes = selectedProduct.data('sizes');
            const productPrice = selectedProduct.data('price');
            const productStock = selectedProduct.data('stock');
            const productPhoto = selectedProduct.data('photo');
        
            productCount++;
        
            // Generate options for color select
            const colors = productColor.split(',')
                                        .filter((_, index) => index % 2 === 0)
                                        .map(color => `<option value="${color.trim()}">${color.trim()}</option>`)
                                        .join('');
        
            const sizes = productSizes.map(size => `<option value="${size.name}" data-price="${size.price}">${size.name}</option>`)
                                      .join('');
        
            const newRow = `
                <tr>
                    <td><button class="btn btn-outline-primary remove-row" type="button">X</button></td>
                    <td>${productCount}<input type="hidden" name="order[${productCount}][product_id]" value="${productId}"></td>
                    <td><img src="{{URL::to('')}}${productPhoto}" alt="product" style="width: 50px; height: auto;"> ${productTitle.substring(0, 25)}..</td>
                    <td><select name="order[${productCount}][color]" class="form-control">${colors}</select></td>
                    <td><select name="order[${productCount}][size]" class="form-control size-select">${sizes}</select></td>
                    <td><input type="number" class="form-control quantity" name="order[${productCount}][quantity]" data-id="${productId}" value="1" style="width: 80px;"></td>
                    <td><span class="price">${productPrice}</span><input type="hidden" name="order[${productCount}][price]" value="${productPrice}" class="price-input" id="price${productId}"></td>
                    <td><p class="subtotal" id="subtotal${productId}">${productPrice}</p></td>
                </tr>
            `;
        
            $('.productable').append(newRow);
            calculateTotal();
        });
        
        $(document).on('change', '.size-select', function() {
            const selectedSize = $(this).find('option:selected');
            const newPrice = selectedSize.data('price');
            const row = $(this).closest('tr');
            row.find('.price').text(newPrice);
            row.find('.price-input').val(newPrice);
            updateSubtotal(row.find('.quantity'));
        });
        
        $(document).on('change', '.quantity', function() {
            updateSubtotal($(this));
        });
        
        $(document).on('click', '.remove-row', function() {
            $(this).closest('tr').remove();
            calculateTotal();
        });
    });
    
    function updateSubtotal(element) {
        const quantity = parseFloat(element.val());
        const row = element.closest('tr');
        const price = parseFloat(row.find('.price-input').val());
        const subtotal = quantity * price;
        row.find('.subtotal').text(subtotal.toFixed(2));
        calculateTotal();
    }
    
    function calculateTotal() {
        let total = 0;
        $('.subtotal').each(function() {
            total += parseFloat($(this).text());
        });
        $('#sub_total').val(total.toFixed(2));
    
        const shippingCost = parseFloat($('#shipping_cost').val()) || 0;
        const discount = parseFloat($('#discount').val()) || 0;
        const payment = parseFloat($('#payment').val()) || 0;
    
        const finalTotal = total + shippingCost - discount;
        $('#total_amount').val(finalTotal.toFixed(2));
    
        const due = finalTotal - payment;
        $('#collectables').val(due.toFixed(2));
    }
</script>

@endpush

