<!DOCTYPE html>
<html>
<head>
    <title>Sales Report</title>
</head>
@php
$settings=DB::table('settings')->where('id',1)->first();
@endphp
@php 
    $stat = App\Models\StatusControl::get();
    $totalorder = App\Models\Order::count();
    $Placed_order = App\Models\Order::where('status','New Order')->count();
    $Cancel_order = App\Models\Order::where('status','Cancel')->count();
    $DeliveryDone = App\Models\Order::where('status','Delivery Done')->count();
@endphp
<style type="text/css">
    body{
        font-family: 'Roboto Condensed', sans-serif;
    }
    .m-0{
        margin: 0px;
    }
    .p-0{
        padding: 0px;
    }
    .pt-5{
        padding-top:5px;
    }
    .mt-10{
        margin-top:10px;
    }
    .text-center{
        text-align:center !important;
    }
    .w-100{
        width: 100%;
    }
    .w-50{
        width:50%;   
    }
    .w-85{
        width:85%;   
    }
    .w-15{
        width:15%;   
    }
    .logo img{
        width:45px;
        height:45px;
        padding-top:30px;
    }
    .logo span{
        margin-left:8px;
        top:19px;
        position: absolute;
        font-weight: bold;
        font-size:25px;
    }
    .gray-color{
        color:#5D5D5D;
    }
    .text-bold{
        font-weight: bold;
    }
    .border{
        border:1px solid black;
    }
    table tr,th,td{
        border: 1px solid #d2d2d2;
        border-collapse:collapse;
        padding:7px 8px;
    }
    table tr th{
        background: #F4F4F4;
        font-size:12px;
    }
    table tr td{
        font-size:10px;
    }
    table{
        border-collapse:collapse;
    }
    .box-text p{
        line-height:10px;
    }
    .float-left{
        float:left;
    }
    .total-part{
        font-size:16px;
        line-height:12px;
    }
    .total-right p{
        padding-right:20px;
    }
</style>
<body>
<div class="head-title">
    <h1 class="text-center m-0 p-0">Order report </h1>
    <p class="text-center">{{$date}}</p>
</div>

<div class="table-section bill-tbl w-100 mt-10">
        <table class="table w-100 mt-10">
            <thead>
                <tr>
                    <th>Order ID</th>
                    <th>Order Details</th>
                    <th>Product</th>
                    <th>Account</th>
                    <th>Date</th>
                    <th>Status</th>
                    <th>Note</th>
                </tr>
            </thead>
            <tbody>
            @if(count($products)>0)
                @foreach($products as $product)   
                @php 
                    $orderdetails=DB::table('order_details')->where('order_id',$product->id)->get();
                    $productdetails=DB::table('products')->where('id',$product->id)->get();
                @endphp
                <tr>
                    <td>
                        {{$settings->order_prefix}}{{$product->id}}
                    </td>
                    <td >
                        {{$product->first_name}}, <br> {{$product->phone}}, <br> {{$product->address}}
                    </td>
                    <td>
                    
                    @foreach($orderdetails as $row)
                    @php 
                        $productdetails=DB::table('products')->where('id',$row->product_id)->first();
                    @endphp
                    <strong>{{$productdetails->title}}</strong> <br>
                    <small>SKU: {{$productdetails->SKU}}</small> <br>
                    <small>@if(isset($row->color)) Color: {{$row->color}} @endif @if(isset($row->size)) Size: {{$row->size}} @endif </small><br>
                    <small>Quantity: {{$row->quantity}}</small> <br>
                    @endforeach
                    </td>
                    <td>
                        Sub Total: {{$product->sub_total}} <br>
                        Shipping Cost: {{$product->shipping_cost}} <br>
                        Discount: {{$product->discount}} <br>
                        Payment: {{$product->payment}} <br>
                        Total Collectables: {{$product->total_amount-$product->payment}} <br>
                        Total Amount: {{$product->total_amount}} <br>

                    </td>
                    <td>{{$product->created_at->format('Y-m-d h:i A')}}</td>
                    <td>
                        <span style="text-transform: capitalize;">{{$product->status}}</span>
                    </td>
                    <td>{{$product->note}}</td>

                </tr>
                @endforeach
                @else
                <h6 class="text-center">No sale found!!!</h6>
                @endif
            </tbody>
        </table>
</div>
</html>