@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Website Setting</h4>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card col-lg-10">
        <div class="card-body">
            <form action="{{ route('general.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Meta Title</label>
                            <input type="text" name="website" value="{{ $data->website }}" required="required">
                            @error('website')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Meta Description</label>
                            <input type="text" name="footer" value="{{ $data->footer }}" required="required">
                            @error('footer')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Meta Keywords</label>
                            <input type="text" name="keywords" value="{{ $data->keywords }}" placeholder="EX: shop, shopping, watch, " required="required">
                            @error('keywords')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Author</label>
                            <input type="text" name="author" value="{{ $data->author }}" required="required">
                            @error('author')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Phone</label>
                            <input type="number" name="phone" value="{{ $data->phone }}" required="required">
                            @error('phone')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" value="{{ $data->email }}" required="required">
                            @error('email')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Address</label>
                            <input type="text" name="address" value="{{ $data->address }}" required="required">

                            @error('address')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Copyright</label>
                            <input type="text" name="copywrite" value="{{ $data->copywrite }}" required="required">
                            @error('copywrite')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-9">
                        <div class="form-group">
                            <img src="{{URL::to('')}}/{{$data->logo}}" alt="" style="height:50px;">
                        </div>
                        <label>Logo</label>
                        <div class="input-group">
                            <span class="input-group-btn">
                                <a id="lfm234" data-input="thumbnail" data-preview="holder" class="btn btn-primary">
                                    <i class="fa fa-picture-o"></i> Choose
                                </a>
                            </span>
                            <input id="thumbnail" class="form-control" value="{{$data->logo}}" name="logo" type="text" >
                        </div>
                        <div id="holder" style="margin-top:15px;max-height:100px;">
                        </div>
                    </div>
                    <div class="col-lg-9">
                        <div class="form-group">
                            <img src="{{URL::to('')}}/{{$data->footer_logo}}" alt=""  style="height:50px;">
                        </div>
                        <label>Footer Logo</label>
                        <div class="input-group">
                            <span class="input-group-btn">
                                <a id="lfm2345" data-input="thumbnail1" data-preview="holder1" class="btn btn-primary">
                                    <i class="fa fa-picture-o"></i> Choose
                                </a>
                            </span>
                            <input id="thumbnail1" class="form-control" value="{{$data->footer_logo}}" name="footer_logo" type="text" >
                        </div>
                        <div id="holder1" style="margin-top:15px;max-height:100px;">
                        </div>
                    </div>
                    
                    <div class="col-lg-9">
                        <div class="form-group">
                            <img src="{{URL::to('')}}/{{$data->fevicon}}" alt="" width="60"  style="height:50px;">
                        </div>
                        <label>Fevicon Logo</label>
                        <div class="input-group">
                            <span class="input-group-btn">
                                <a id="lfm2346asd" data-input="thumbnail3" data-preview="holder3" class="btn btn-primary">
                                    <i class="fa fa-picture-o"></i> Choose
                                </a>
                            </span>
                            <input id="thumbnail3" class="form-control" value="{{$data->fevicon}}" name="fevicon" type="text" >
                        </div>
                        <div id="holder3" style="margin-top:15px;max-height:100px;">
                        </div>
                    </div>
                    
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>
<script>
    (function($) {

$.fn.filemanager = function(type, options) {
    type = type || 'file';

    this.on('click', function(e) {
        var route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
        var target_input = $('#' + $(this).data('input'));
        var target_preview = $('#' + $(this).data('preview'));
        window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
        window.SetUrl = function(items) {
            var file_path = items.map(function(item) {
                return item.url;
            }).join(',');

            var url = '{{url('/')}}';
            var myNewStr = file_path.replace(url, '');
            file_path = myNewStr;
            // set the value of the desired input to image url
            target_input.val('').val(file_path).trigger('change');

            // clear previous preview
            target_preview.html('');

            // set or change the preview image src
            items.forEach(function(item) {
                target_preview.append(
                    $('<img>').css('width', '5rem').attr('src', item.thumb_url)
                );
            });

            // trigger change event
            target_preview.trigger('change');
        };
        return false;
    });
}

})(jQuery);

var route_prefix = "{{ url('')}}/filemanager";
$('#lfm234').filemanager('', {
prefix: route_prefix
});
$('#lfm2345').filemanager('', {
prefix: route_prefix
});
$('#lfm2346').filemanager('', {
prefix: route_prefix
});
$('#lfm2346asd').filemanager('', {
prefix: route_prefix
});
</script>
@endpush