@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content d-none">
    <div class="page-header">
        <div class="page-title">
            <h4>Product Page Edit</h4>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @include('backend.layouts.notification')
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <form action="{{ route('productview.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <h3 class="text-center">Order Success Page Edit</h3><br>

                <div class="row">
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Order Prefix*</label>
                            <input type="text" name="order_prefix" value="{{ $data->order_prefix }}" >
                            @error('order_prefix')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>Order Page Title*</label>
                            <input type="text" name="order_page_title" value="{{ $data->order_page_title }}" >
                            @error('order_page_title')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>Order Page Summary</label>
                            <textarea class="form-control" id="description" name="order_page">{!! $data->order_page!!}</textarea>
                            @error('order_page')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <img src="{{URL::to('')}}/{{$data->order_page_image}}" alt="">
                        </div>
                        <label>Order Page Icon*</label>
                        <div class="input-group">
                            <span class="input-group-btn">
                                <a id="lfm234" data-input="thumbnail" data-preview="holder" class="btn btn-primary">
                                    <i class="fa fa-picture-o"></i> Choose
                                </a>
                            </span>
                            <input id="thumbnail" class="form-control" value="{{$data->order_page_image}}" name="order_page_image" type="text" >
                        </div>
                        <div id="holder" style="margin-top:15px;max-height:100px;">
                        </div>
                    </div>
                </div><br>
                <h3 class="text-center">Product Page Edit</h3><br>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>Product Summary</label>
                            <textarea class="form-control" id="summary" name="product_summary">{!! $data->product_summary!!}</textarea>
                            @error('product_summary')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                <h3 class="text-center">Payment Cash on Delivery Edit</h3><br>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>Cash on Delivery instruction</label>
                            <input class="form-control" id="summary" name="cash_on_delivery_text" value="{{ $data->cash_on_delivery_text}}">
                            @error('cash_on_delivery_text')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label>Bank Delivery instruction</label>
                            <input class="form-control" id="summary" name="bank_delivery_text" value="{{ $data->bank_delivery_text}}">
                            @error('bank_delivery_text')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                <h3 class="text-center">No Order Page Edit</h3><br>
                <div class="row">

                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>No Order return link (Leave empty to redirect default home page)</label>
                            <input type="text" name="checkout_link" value="{{ $data->checkout_link }}" >
                            @error('checkout_link')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 col-12">
                        <div class="form-group">
                            <label>No Order return link button text</label>
                            <input type="text" name="checkout_button_text" value="{{ $data->checkout_button_text }}" >
                            @error('checkout_button_text')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label>No Order Text*</label>
                            <textarea class="form-control" id="description" name="checkout_text">{!! $data->checkout_text!!}</textarea>
                            @error('checkout_text')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <img src="{{URL::to('')}}/{{$data->checkout_image}}" alt="">
                        </div>
                        <label>No Order Page Image</label>
                        <div class="input-group">
                            <span class="input-group-btn">
                                <a id="lfmsdf2346" data-input="thumbnailasc" data-preview="holderasd" class="btn btn-primary">
                                    <i class="fa fa-picture-o"></i> Choose
                                </a>
                            </span>
                            <input id="thumbnailasc" class="form-control" value="{{$data->checkout_image}}" name="checkout_image" type="text" >
                        </div>
                        <div id="holderasd" style="margin-top:15px;max-height:100px;">
                        </div>
                    </div>
                </div><br>
                <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>
<script>
    (function($) {

$.fn.filemanager = function(type, options) {
    type = type || 'file';

    this.on('click', function(e) {
        var route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
        var target_input = $('#' + $(this).data('input'));
        var target_preview = $('#' + $(this).data('preview'));
        window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
        window.SetUrl = function(items) {
            var file_path = items.map(function(item) {
                return item.url;
            }).join(',');

            var url = '{{url('/')}}';
            var myNewStr = file_path.replace(url, '');
            file_path = myNewStr;
            // set the value of the desired input to image url
            target_input.val('').val(file_path).trigger('change');

            // clear previous preview
            target_preview.html('');

            // set or change the preview image src
            items.forEach(function(item) {
                target_preview.append(
                    $('<img>').css('width', '5rem').attr('src', item.thumb_url)
                );
            });

            // trigger change event
            target_preview.trigger('change');
        };
        return false;
    });
}

})(jQuery);

var route_prefix = "{{ url('')}}/filemanager";
$('#lfm234').filemanager('', {
prefix: route_prefix
});
$('#lfm2345').filemanager('', {
prefix: route_prefix
});
$('#lfm2346').filemanager('', {
prefix: route_prefix
});
$('#lfmsdf2346').filemanager('', {
prefix: route_prefix
});
</script>
@endpush