@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>Shipping  Edit</h4>
            <h6>Edit Shipping</h6>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('shipping.update',$data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">
                    <input type="hidden" name="state_id" value="1">
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            <input type="text" name="type" value="{{ $data->type }}" required="required" placeholder="Method Name">
                            @error('type')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form-group">
                            
                            <input type="number" name="price" value="{{ $data->price }}" required="required" placeholder="Amount">
                            @error('price')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                    </div>
                   
                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')
<script>
tinymce.init({
    selector: 'textarea',
    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
});
</script>

@endpush