@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>SMS Template Add</h4>
            <h6>Create new SMS Template</h6>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('sms_template.store')}}" method="POST" enctype="multipart/form-data">
                @CSRF
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">



                    <div class="col-lg-12 col-sm-6 col-12">
                        <div class="form-group">
                            <label>SMS for</label>
                            <select class="select" name="sms_for"> 
                                <option value="New Order" @foreach($data as $chsd) @if($chsd->sms_for == "New Order") disabled @endif @endforeach  >New Order</option>
                                @foreach($products as $row)
                                <option value="{{$row->name}}" @foreach($data as $chsd) @if($chsd->sms_for == $row->name) disabled @endif @endforeach>{{$row->name}}</option>
                                @endforeach
                                <option value="Delivery Done" @foreach($data as $chsd) @if($chsd->sms_for == "Delivery Done") disabled @endif @endforeach >Delivery Done</option>
                                <option value="Courier" @foreach($data as $chsd) @if($chsd->sms_for == "Courier") disabled @endif @endforeach >Courier</option>
                                <option value="Cancel" @foreach($data as $chsd) @if($chsd->sms_for == "Cancel") disabled @endif @endforeach >Cancel</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-lg-12 col-sm-12 col-12" >
                        <div class="form-group">
                            <label>SMS Tempate</label>
                            <textarea name="message" id="" cols="30" rows="10"></textarea>
                            @error('message')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                        <div >
                            Order ID: {id} <br>
                            Order Sub Total: {sub_total} <br>
                            Order Discount: {discount} <br>
                            Order Collectables: {collectables} <br>
                            Order Amount: {amount} <br>
                            Order Shipping Cost: {shipping_cost} <br>
                            Custome Name: {name} <br>
                            Custome Phone: {phone} <br>
                            Custome Address: {address} <br>
                        </div><br>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-12" >
                        <div class="form-group">
                            <label>Status</label>
                            <select class="select" name="status">
                                <option value="on">On</option>
                                <option value="off">Off</option>
                            </select>
                        </div>
                    </div>


                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')


@endpush