@extends('backend.layouts.app')

@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp

<div class="content">
    <div class="page-header">
        <div class="page-title">
            <h4>SMS Template  Edit</h4>
            <h6>Edit SMS Template</h6>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('sms_template.update', $data->id)}}" method="POST" enctype="multipart/form-data">
            @csrf 
        @method('PATCH')
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <div class="row">


                <div class="col-lg-12 col-sm-6 col-12">
                    <div class="form-group">
                            <label>SMS for</label>
                            <input type="text" name="sms_for" value="{{$data->sms_for}}" readonly="readonly">
                        </div>
                    </div>
                    
                    <div class="col-lg-12 col-sm-12 col-12">
                        <div class="form-group">
                            <label>SMS Tempate</label>
                            <textarea name="message" id="" cols="30" rows="10">{{$data->message}}</textarea>
                            @error('message')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                        <div>
                            Order ID: {id} <br>
                            Order Sub Total: {sub_total} <br>
                            Order Discount: {discount} <br>
                            Order Collectables: {collectables} <br>
                            Order Amount: {amount} <br>
                            Order Shipping Cost: {shipping_cost} <br>
                            Custome Name: {name} <br>
                            Custome Phone: {phone} <br>
                            Custome Address: {address} <br>
                        </div><br>
                    </div>
                    <div class="col-lg-3 col-sm-6 col-12">
                        <div class="form-group">
                            <label>Status</label>
                            <select class="select" name="status">
                                <option value="on" @if($data->status == 'on') selected @endif>On</option>
                                <option value="off" @if($data->status == 'off') selected @endif>Off</option>
                            </select>
                        </div>
                    </div>


                    <div class="col-lg-12">
                        <button type="submit" class="btn btn-submit me-2">Submit</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

</div>
@endsection

@push('styles')

@endpush
@push('scripts')

@endpush