@extends('backend.layouts.app')
@section('content')
@php $general = App\Models\Setting::where('id','=','1')->first(); @endphp
<div class="content">
   <div class="page-header">
      <div class="page-title">
         <h4>Products</h4>
      </div>
   </div>
   <div class="card col-lg-12 col-sm-8 col-12 ">
      <div class="card-body">
         <h5>CREATE PRODUCT</h5>
         <br>
         <form action="{{ route('product.store')}}" method="POST" enctype="multipart/form-data">
            @CSRF
            @if ($errors->any())
            <div class="alert alert-danger">
               <ul>
                  @foreach ($errors->all() as $error)
                  <li>{{ $error }}</li>
                  @endforeach
               </ul>
            </div>
            @endif
            <div class="row">
               <div class="col-lg-6 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Select Category*</label>
                     <select class="select" name="cat_id[]" multiple>
                        <option>Choose Category</option>
                        @foreach($categories as $key=>$cat_data)
                        <option value='{{$cat_data->id}}'>{{$cat_data->title}}</option>
                        
                        @php
                        $category=DB::table('categories')->where('parent_id','=',$cat_data->id)->get();
                        @endphp
                        
                        @foreach($category as $row)
                        <option value='{{$row->id}}'>-{{$row->title}}</option>
                        @endforeach
                        
                        
                        
                        @endforeach
                     </select>
                  </div>
               </div>
               <div class="col-lg-6 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Brand</label>
                     <select class="select" name="br_id[]" multiple>
                        <option>Choose Brand</option>
                        @foreach($brands as $brand)
                        <option value='{{$brand->id}}'>{{$brand->title}}</option>
                        @endforeach
                     </select>
                  </div>
               </div>
               <div class="col-lg-12 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Product Name*</label>
                     <input type="text" name="title" value="{{old('title')}}" required="required">
                     @error('title')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               
               <div class="col-lg-4 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Product Cost Price</label>
                     <input type="number" name="cost" value="{{old('cost')}}" required="required">
                     @error('cost')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               <div class="col-lg-4 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Regular Price</label>
                     <input type="number" name="price" id="price" value="{{old('price')}}" >
                     @error('price')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               <div class="col-lg-4 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Sale Price</label>
                     <input type="number" name="offer_price" id="offer_price" value="{{old('offer_price')}}" required="required">
                     @error('offer_price')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               <input type="hidden" name="discount" id="discount" value="{{old('discount')}}">
               <div class="col-lg-3 col-sm-8 col-12">
                  <div class="form-group">
                     <label>SKU</label>
                     <input type="text" name="SKU" placeholder="optional" value="{{old('SKU')}}">
                     @error('SKU')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               <div class="col-lg-3 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Stock</label>
                     <input type="number" min="0" name="stock" value="{{old('0')}}" required="required">
                     @error('stock')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               <div class="col-lg-3 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Unit (Kg,pc)</label>
                     <input type="text" name="unit" value="{{old('unit')}}">
                     @error('unit')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               <div class="col-lg-3 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Video </label>
                     <input type="text" name="video" value=""
                        placeholder="Embed Video Url">
                     @error('video')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               <div class="col-lg-12">
                  <div class="form-group">
                     <label>Short Description</label>
                     <textarea class="form-control" id="summary" name="summary">{{old('summary')}}</textarea>
                     @error('summary')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               <div class="col-lg-12">
                  <div class="form-group">
                     <label>Long Description</label>
                     <textarea class="form-control" id="description"
                        name="description">{{old('description')}}</textarea>
                     @error('description')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               <div class="col-lg-6">
                  <label>Main Product Image (750*750 pixel)</label>
                  <div class="input-group">
                     <span class="input-group-btn">
                     <a id="lfm234" data-input="thumbnail" data-preview="holder" class="btn btn-primary">
                     <i class="fa fa-picture-o"></i> Choose
                     </a>
                     </span>
                     <input id="thumbnail" class="form-control" name="photo" type="text" >
                  </div>
                  <div id="holder" style="margin-top:15px;max-height:100px;">
                  </div>
               </div>
               <div class="col-lg-6">
                  <label>Product Gallery (750*750 pixel)</label>
                  <div class="input-group">
                     <span class="input-group-btn">
                     <a id="gallery" data-input="thumbnailgallery" data-preview="galleryholder" class="btn btn-primary">
                     <i class="fa fa-picture-o"></i> Choose
                     </a>
                     </span>
                     <input id="thumbnailgallery" class="form-control" name="gallery" type="text" >
                  </div>
                  <div id="galleryholder" style="margin-top:15px;max-height:100px;">
                  </div>
               </div>

               <div class="col-lg-3 col-sm-6 col-12 mb-3">
                            <label  class="form-label">Product Type</label>
                            <select name="type" id="prod_type" class="form-control">
                                <option value="single">Single</option>
                                <option value="variable">Variations</option>
                            </select>
                        </div>

                  <div class="col-lg-3 col-sm-6 col-12">
                        <div class="form-group">
                            <label> Cash on Delivery</label>
                            <select class="select" name="cod">
                                <option value="on" selected>On</option>
                                <option value="off">Off</option>
                            </select>
                        </div>
                    </div>     
                    <div class="col-lg-3 col-sm-6 col-12">
                            <label  class="form-label">Partial Payment</label>
                            <select name="bkashpar" id="par_type" class="form-control">
                                <option value="off">Off</option>
                                <option value="on">On</option>
                            </select>
                        </div> 

               <div class="col-lg-3 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Product Status</label>
                     <select class="select" name="status">
                        <option value="active" selected>Active</option>
                        <option value="inactive">Inactive</option>
                     </select>
                  </div>
               </div>
               <div class="col-lg-12 col-sm-8 col-12">
                  <div class="form-group">
                     <label>Free Shipping</label>
                     <select class="select" name="freeshipping">
                        <option value="inactive">Active</option>
                        <option value="active" selected>Inactive</option>
                     </select>
                  </div>
               </div>
               <div id="par_table" style="display: none;">
               <div class="row">
               <div class="col-lg-4 col-sm-8 col-12">
                  <div class="form-group">

                  <p style="color:red;">(Cash On Delivery) ক্যাশ অন ডেলিভারি অফ করে দিন.</p>

                     <label>Partial Payment </label>
                     <input type="number" name="par_price" id="par_price" value=""
                        placeholder=" ">
                     @error('par_price')
                     <span class="text-danger">{{$message}}</span>
                     @enderror
                  </div>
               </div>
               </div>
               </div>
               <div id="variable_table" style="display: none;">
<div class="row">
               <div class="col-lg-6 col-sm-8 col-12 mt-3 mb-3">
                  <table class="table">
                  <thead>
                              <tr>
                                 <th>Color</th>
                                 <th>Color Image (Single Image Only)</th>
                                 
                                 <th>Action</th>
                              </tr>
                           </thead>
                     <tbody class="attdirbvj">
                        <tr>
                           
                           <td>
                              <div class="mb-0">
                                 
                                 <input class="form-control w-100" multiple="multiple" name="colors[]">
                              </div>
                           </td>
                           <td>
                              <div class="mb-0">
                                 
                                 <div class="input-group">
                                    <span class="input-group-btn">
                                    <a id="lfm0" data-input="thumbnail0" data-preview="holder0"
                                       class="btn btn-primary text-white">
                                    <i class="fa fa-picture-o"></i> Choose
                                    </a>
                                    </span>
                                    <input id="thumbnail0" class="form-control w-60" name="colors[]" type="text">
                                    

                                 </div>
                              </div>
                           </td>
                           <td>
                              <label class="d-block form-label">&nbsp;</label>
                              <button class="btn btn-icon btn-icon-only btn-outline-primary" type="button">
                              X
                              </button>
                           </td>
                        </tr>
                     </tbody>
                  </table>
                  <div class="mb-3 pb-3 border-bottom text-center">
                     <button type="button"
                        class="addnewatt btn btn-success hover-outline btn-icon btn-icon-start mt-2">
                     <i data-cs-icon="plus"></i>
                     <span>Add More</span>
                     </button>
                  </div>
               </div>
               <div class="col-lg-6 col-sm-8 col-12 mt-3 mb-3">
                  <div id="variables_table" class="col-md-12">
                     <div class="table-responsive">
                        <table id="size_table" class="table table-centered table-nowrap table-bordered text-center">
                           <thead>
                              <tr>
                                 <th>Size</th>
                                 <th style="width: 20%;">Price</th>
                                 <th style="width: 20%;">Stock</th>
                                 <th width="5">Action</th>
                              </tr>
                           </thead>
                           <tbody>
                              <tr>
                                 <td>
                                    <div class="col-lg-12 col-sm-8 col-12">
                                       <div class="form-group">
                                          <label>Size</label>
                                          <select class="select" name="size_id[]">
                                             <option>Choose Size</option>
                                             @foreach($sizes as $size)
                                             <option value='{{$size->id}}'>{{$size->name}}</option>
                                             @endforeach
                                          </select>
                                       </div>
                                    </div>
                                 </td>
                                 <td>
                                    <input class="form-control" type="number" name="size_price[]" placeholder="Price">
                                 </td>
                                 <td>
                                    <input class="form-control" type="number" name="size_stock[]" placeholder="Stock">
                                 </td>
                                 <td>
                                    <button type="button" class="btn btn-danger btn-sm remove_ro">Remove</button>
                                 </td>
                              </tr>
                           </tbody>
                        </table>
                        <div class="mb-3 pb-3 border-bottom text-center">
                        <button type="button" class="btn btn-success hover-outline btn-icon btn-icon-start mt-2 add_more">Add More</button>
                        </div>
                     </div>
                  </div>
               </div>
               </div>
</div>
               <div class="col-lg-12">
                  <button type="submit" class="btn btn-submit me-2">Submit</button>
               </div>
            </div>
         </form>
      </div>
   </div>
</div>
@endsection
@push('styles')
<style>
   .select2-container .select2-selection--multiple {
   min-height: 40px;
   }
</style>
@endpush
@push('scripts')
<script>
   tinymce.init({
       selector: 'textarea:not(.no-tinymce)',
       plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
       toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
   });
</script>

<script>
   $(document).ready(function() {
       // Add more rows
       $(".add_more").click(function() {
           var html = '<tr>' +
               '<td><select name="size_id[]" class="form-control">@foreach($sizes as $size)<option value="{{$size->id}}">{{ $size->name }}</option>@endforeach</select></td>' +
               '<td><input class="form-control" type="number" name="size_price[]" placeholder="Price"></td>' +
               '<td><input class="form-control" type="number" name="size_stock[]" placeholder="Stock"></td>' +
               '<td><button type="button" class="btn btn-danger btn-sm remove_row">Remove</button></td>' +
               '</tr>';
           $("#size_table tbody").append(html);
       });
   
       // Remove row
       $("body").on("click", ".remove_row", function() {
           $(this).closest("tr").remove();
       });
   });
   $(document).on('change',"select[name='type']", function(){
            let type=$("select[name='type']").val();
            if(type != 'single')
            {
                
                document.getElementById('variable_table').style.display = 'block';
            } else {
                document.getElementById('variable_table').style.display = 'none';
            }
        });

        $(document).on('change',"select[name='bkashpar']", function(){
            let type=$("select[name='bkashpar']").val();
            if(type != 'off')
            {
                
                document.getElementById('par_table').style.display = 'block';
            } else {
                document.getElementById('par_table').style.display = 'none';
            }
        });
</script>
<script type="text/javascript">
   (function($) {
   
       $.fn.filemanager = function(type, options) {
           type = type || 'file';
   
           this.on('click', function(e) {
               var route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
               var target_input = $('#' + $(this).data('input'));
               var target_preview = $('#' + $(this).data('preview'));
               window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
               window.SetUrl = function(items) {
                   var file_path = items.map(function(item) {
                       var url = '{{url('/')}}';
                       var myNewStr = item.url.replace(url, '');
                       return myNewStr;
                   }).join(',');
   
                   var url = '{{url('/')}}';
                   var myNewStr = file_path.replace(url, '');
                   file_path = myNewStr;
                   // set the value of the desired input to image url
                   target_input.val('').val(file_path).trigger('change');
   
                   // clear previous preview
                   target_preview.html('');
   
                   // set or change the preview image src
                   items.forEach(function(item) {
                       target_preview.append(
                           $('<img>').css('width', '5rem').attr('src', item.thumb_url)
                       );
                   });
   
                   // trigger change event
                   target_preview.trigger('change');
               };
               return false;
           });
       }
   
   })(jQuery);
   
   var route_prefix = "{{ url('')}}/filemanager";
   $('#lfm234').filemanager('', {
       prefix: route_prefix
   });
   
   $('#lfm0').filemanager('', {prefix: route_prefix});
   $('#gallery').filemanager('', {
       prefix: route_prefix
   });
   
   $(document).on('click', '.remove-tr', function() {
       $(this).parents('tr').remove();
   });
   
   
   $('.addnewatt').on('click', function() {
       addr();
   });
   let jd = 0;
   
   function addr() {
       jd++;
   
       var tr = '<tr><td><div class="mb-0"><label class="form-label">Color</label> <input class="form-control w-80" multiple="multiple" name="colors[]"> </div> </td> <td> <div class="mb-0"> <label class="form-label">Color Image (Single Image Only)</label> <div class="input-group"> <span class="input-group-btn"> <a id="lfm' + jd + '" data-input="thumbnail' + jd + '" data-preview="holder' + jd + '" class="btn btn-primary text-white"> <i class="fa fa-picture-o"></i> Choose </a> </span> <input id="thumbnail' + jd + '" class="form-control w-100" name="colors[]" type="text" > </div> </div> </td> <td> <label class="d-block form-label">&nbsp;</label> <button class="btn btn-icon btn-icon-only btn-outline-primary remove-tr" type="button"> X </button> </td> </tr>'  
       $('.attdirbvj').append(tr);
       $('#lfm1').filemanager('', {
       prefix: route_prefix
   });
   $('#lfm2').filemanager('', {
       prefix: route_prefix
   });
   $('#lfm3').filemanager('', {
       prefix: route_prefix
   });
   $('#lfm4').filemanager('', {
       prefix: route_prefix
   });
   $('#lfm5').filemanager('', {
       prefix: route_prefix
   });
   $('#lfm6').filemanager('', {
       prefix: route_prefix
   });
   $('#lfm7').filemanager('', {
       prefix: route_prefix
   });
   $('#lfm8').filemanager('', {
       prefix: route_prefix
   });
   $('#lfm9').filemanager('', {
       prefix: route_prefix
   });
   $('#lfm10').filemanager('', {
       prefix: route_prefix
   });
   $('#lfm11').filemanager('', {
       prefix: route_prefix
   });
   
   };
</script>
<script>
   $('#offer_price').on('keyup', function(){
       var price = $('#price').val();
       var offerprice = $('#offer_price').val();
       var discount = (offerprice  / price) * 100;
       var total = 100-discount.toFixed(2);
       $('#discount').val(Math.round(total));
   });
</script>
<script>
   $('#price').on('keyup', function(){
       var price = $('#price').val();
       var offerprice = $('#offer_price').val();
       var discount = (offerprice  / price) * 100;
       var total = 100-discount.toFixed(2);
       $('#discount').val(Math.round(total));
   });
</script>
@endpush