@extends('layouts.app')
@php
$setting=DB::table('settings')->first();
$states=DB::table('states')->get();
$shippings=DB::table('shippings')->get();
@endphp
@section('meta')
<title>Checkout | {{$setting->website}}</title>
@endsection
@section('content')

@php
$items = \Cart::session(csrf_token())->getContent();
$codstatus = 1;
$bankstatus = 1;
$bkashpar = 1;
@endphp

@if(isset($items) && count($items) >0)
<div class="checkout-area pt-4 pb-30 ">
    <div class="container row col-12" style="margin: 0 auto; background-color: #F1F1F1;">
        <!--<div class="row">
    <div class="col-md-6 mb-4" style="padding: 0 35px;">
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        <span style="font-size: 18px;">
             @if(session()->has('coupon')) Coupon Code ({{ Session::get('coupon')['code'] }}) Accepted! Your order total has been updated.@endif
        </span>
        <br>
        @if(!session()->has('coupon'))
        <form action="{{ route('coupon-store') }}" id="couponstoreform" method="POST" style="display: flex; flex-direction: row; align-items: center;">
            @CSRF
            <input type="text" class="form-control code" name="code" placeholder="Enter promo code if you have one" style="width: 80%;">
            @error('code')
                <span class="text-danger">{{ $message }}</span>
            @enderror
            <button class="btn btn-sm" type="submit" style="margin-left: -30px; background: black; color: white; border-radius: 7px; padding: 5px 7px;">Validate Code</button>
        </form>
        @else
        <form action="{{ route('coupon-remove') }}" method="POST" style="display: flex; flex-direction: row; align-items: center;">
            @CSRF
            <button class="btn btn-sm" type="submit" style="background: red; color: white; border-radius: 7px; padding: 5px 7px;">Remove Coupon</button>
        </form>
        @endif
    </div>
</div>-->

        <form action="{{route('order.submit')}}" class="col-lg-6" id="submitcheckout" method="POST" enctype="multipart/form-data">
            @CSRF
            
            <div class="row ">
                <div class="col-lg-12 mb-4">
                    <div class="order-summary shadow border-new">
                        <div class="order-summary-title">
                            <div class="billing-info-wrap row" style="padding: 0 15px;">
                
                                <div class="col-lg-12 mb-3">
                                    <h4 style="font-size: 18px;text-align: center;">
                                        <span class="text-danger">*সম্মানিত ক্রেতা </span>অর্ডারটি কনফার্ম করতে আপনার নাম, সম্পূর্ণ ঠিকানা, মোবাইল নাম্বার লিখে<span style="color: red;"> অর্ডার কনফার্ম করুন </span> বাটনে ক্লিক করুন।
                                    </h4>
                                </div>
                                <div class="col-lg-12 mb-4">
                                    <input type="text" class="form-contro " name="customerName" @auth value="{{Auth()->user()->name}}" @endauth @guest value="{{old('customerName')}}" @endguest required placeholder="এখানে নাম লিখুন">
                                    @error('customerName')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-12 mb-4">
                                    <input type="number" class="form-contro customerPhone" @auth value="{{Auth()->user()->phone}}" @endauth @guest value="{{old('customerPhone')}}" @endguest name="customerPhone" required placeholder="এখানে মোবাইল নম্বর লিখুন 01...">
                                    @error('customerPhone')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-12 mb-4">
                                    <input type="text" class="form-contro " name="customerAddress" value="{{old('customerAddress')}}" required placeholder="এখানে সম্পূর্ণ ঠিকানা লিখুন">
                                    @error('customerAddress')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                @php
                                $productCount = count($items);
                                $freeShipping = null;
                                foreach($items as $data) {
                                $freeShipping = DB::table('products')->where('id', $data->associatedModel->id)->where('freeshipping', 'active')->first();
                                if($freeShipping != null) {
                                break; // Exit the loop if any product has free shipping
                                }
                                }
                                @endphp

                                @if ($freeShipping != null)
                                <div class="col-lg-12 mb-4">
                                    <label for="Address"><strong>ডেলিভারী এরিয়া</strong> <span style="color:red;">*</span></label>
                                    <select class="form-control customerShipping" id="customerShipping" required name="customerShipping">
                                        <option value="0">ডেলিভারী এরিয়া সিলেক্ট করুন</option>
                                        @foreach($shippings as $rowsc)
                                        <option value="{{$rowsc->price}}" data-id="{{$rowsc->id}}">{{$rowsc->type}}</option>
                                        @endforeach
                                    </select>
                                    @error('customerShipping')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                @else ($productCount == 1)
                                <div class="col-lg-12 mb-4">
                                    <select class="form-control" required name="customerShipping">
                                        <option value="0">Free Shipping</option>
                                    </select>
                                    @error('customerShipping')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                @endif

                              
                            </div>
        </form>
    </div>
    <div class="col-lg-12 mb-4">
        <div class="billing-info-wrap">
            @if(!session()->has('coupon'))
            @endif
            <div class="billing-info-wrap">
                @if(!session()->has('coupon'))
                @endif
                <div class="col-lg-12 mb-4">
                    <span style="font-size: 18px;">Select Payment Method:</span>

                </div> @foreach($items as $data)
                @php
                $producd=DB::table('products')->where('id','=',$data->associatedModel->id)->first();
                $ptol=DB::table('products')->where('id','=',$data->associatedModel->id)->get();
                $ptols = $ptol->sum('par_price');
                if($producd->cod == 'off'){
                $codstatus = 0;
                }
                if($producd->bank == 'off'){
                $bankstatus = 0;
                }
                if($producd->bkashpar == 'off'){
                $bkashpar = 0;
                }
                @endphp
                @endforeach
                <div class="col-lg-12 mb-4">
                    @error('payment_method')
                    <span class="text-danger">Please select a payment method</span>
                    @enderror
                    <div class="">
                        @if($codstatus == 1)
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" checked style="background: none; border: none;box-shadow:none;" type="radio" required name="payment_method" id="cod" value="cod">
                            <label class="form-check-label paym activepay" data-method="cod" for="cod"><img src="{{URL::to('')}}/public/assets/img/icons/cod.png" alt="img" style="height: 40px;width: 40px;"></label>
                        </div>
                        @endif
                        @if($bkashpar == 1 )
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" style="background: none; border: none;box-shadow:none;" type="radio" required name="payment_method" id="bkashpar" value="bkashpar">
                            <label class="form-check-label paym activepay" data-method="bkashpar" for="bkashpar"><img src="{{URL::to('')}}/public/assets/img/icons/advancepayment.jpg" alt="img" style="height: 40px;width: 40px;"></label>

                        </div>
                        @endif

                        <div class="form-check form-check-inline">
                            <input class="form-check-input" style="background: none; border: none;box-shadow:none;" type="radio" required name="payment_method" id="bkash" value="bkash">
                            <label class="form-check-label paym" data-method="bkash" for="bkash"><img src="{{URL::to('')}}/public/assets/img/icons/bkashpay.png" alt="img" style="height: 40px;width: 40px;"></label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" style="background: none; border: none;box-shadow:none;" type="radio" required name="payment_method" id="uddoktapay" value="uddoktapay">
                            <label class="form-check-label paym" data-method="uddoktapay" for="uddoktapay"><img src="{{URL::to('')}}/public/assets/img/icons/uddoktapay.png" alt="img" style="height: 40px;width: 100px;"></label>
                        </div>
                        @if($bkashpar == 1)
                        <div class="mt-2" id="bkashpars" style=" background: rgb(243 243 243); color: red; padding: 20px; border-radius: 5px; margin-bottom: 10px;">
                            আপনাকে {{$ptols}} টাকা এডভান্স পেমেন্ট করতে হবে।
                        </div>
                        @endif
                    </div>


                </div>

            </div>
            <div class="col-lg-12 mb-4">
                <div class="grand-total-btn">
                    <button type="submit" class="btn btn-success btn-block btn-lg" style="background:#fc8934; border-radius: 3px; width: 100%;border-color: #fc8934; color:{{$setting->header_text_color}} !important;">অর্ডার কনফার্ম করুন</button>
                </div>
            </div>
            @include('layouts.notification')

            @foreach($items as $data)

            @php
            $liquid = DB::table('liquids')->where('id',$data->attributes->liquid)->first();
            @endphp
            @if($liquid)
            <input type="hidden" name="liquidName" value="{{$liquid->name}}">
            @endif


            @php
            $size = DB::table('sizes')->where('id',$data->attributes->size)->first();
            @endphp


            @if($size)
            <input type="hidden" name="sizeName" value="{{$size->name}}">
            @endif
            @endforeach



        </div>
    </div>
</div>
</div>
<input type="text" value="" name="city" id="city" hidden>
</div>
</form>
<div class="col-lg-6 " style="padding: 0;">
    <div class="col-lg-12 mb-4">
        <div class="order-summary shadow border-new">

            <div class="order-summary-top">
                <div class="cart-table-content table-responsive">
                    <table class="table-striped table">
                        <thead>
                            <tr class="bg-white">
                                <th class="width-thumbnail"></th>
                                <th class="width-thumbnail" colspan="2">Product Details </th>
                                <th class="width-quantity">Quantity </th>
                                <th class="width-subtotal">Price</th>
                            </tr>
                        </thead>
                        <tbody>

                            @foreach($items as $data)
                            @php
                            $producd = DB::table('products')
                            ->where('id', '=', $data->associatedModel->id)
                            ->first(); // Use first() instead of all() to retrieve a single record

                            $colors = explode(',', $producd->color);
                            if($producd->cod == 'off'){
                            $codstatus = 0;
                            }
                            if($producd->bank == 'off'){
                            $bankstatus = 0;
                            }
                            @endphp


                            @php
                            $size = DB::table('sizes')->where('id',$data->attributes->size)->first();
                            @endphp

                            @php
                            $liquid = DB::table('liquids')->where('id',$data->attributes->liquid)->first();
                            @endphp



                            <tr id="deletecart{{$data->id}}">
                                <td>
                                    <a href="javascript:void(0);" class="deletecart" data-id="{{$data->id}}">
                                        <i class="fas fa-trash text-danger"></i>
                                    </a>
                                </td>
                                <td style="width: 60px;">

                                    @if($data->attributes->color !== null)
                                    @foreach(array_chunk($colors, 2) as $color)
                                    @if($color[0] == $data->attributes->color)
                                    <img class="default-img" loading="lazy" style="max-width: 60px;" src="{{ URL::to('') }}/{{ $color[1] }}">
                                    @endif
                                    @endforeach
                                    @else
                                    <img class="default-img" loading="lazy" style="max-width: 60px;" src="{{URL::to('')}}/{{$producd->photo}}">
                                    @endif

                                </td>
                                <td class="text-left">
                                    <p class="m-0">{{$producd->title}}</p> @if($data->attributes->color) {{$data->attributes->color}} @endif @if($data->attributes->color && $size) - @endif @if($size) {{$size->name}} @endif
                                    @if($data->attributes->color && $liquid) - @endif @if($liquid) {{$liquid->name}} @endif <br>
                                    <span class="badge bg-success"></span>
                                    <span class="badge bg-primary"></span>
                                </td>
                                <td class="quantity">
                                    <div class="" id="myformm" style="border:1px solid #fc8934;">
                                        <input type='button' value='-' class='base-color qtyminus minuscart' data-id="{{$data->id}}" field='quantity' color:{{$setting->header_text_color}};" />
                                        <input type='text' readonly="readonly" name='quantity' value='{{$data->quantity}}' class='qty quantitycart{{$data->id}}' id="quantitycart{{$data->id}}" />
                                        <input type='button' value='+' class='base-color qtyplus pluscart' data-id="{{$data->id}}" field='quantity' color:{{$setting->header_text_color}};" />
                                    </div>
                                </td>
                                <td>Tk {{ $data->price}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="order-summary-middle">
                <ul>
                    <li>Subtotal: <span>Tk <span id="totalamount" class="totalamount">{{\Cart::session(csrf_token())->getTotal()}}</span></span></h4>
                    </li>
                   <!-- @if(session()->has('coupon'))
                <li>Discount 
                    <span>Tk <span class="coupon" id="couponprice">{{number_format(Session::get('coupon')['value'],2)}}</span></span>
                </li>
                @else
                <li>Discount 
                    <span>Tk <span class="coupon" id="couponprice">0.00</span></span>
                </li>
                @endif -->
                    <li>Delivery charge:
                        <span>Tk <span class="price" id="shipprice">0</span></span>

                    </li>
                </ul>
            </div>
            @php
            $total =0;
            $total = $total+\Cart::session(csrf_token())->getTotal();
            if(session()->has('coupon')){
            $total = $total-session()->get('coupon')['value'];
            }
            @endphp
            <div class="order-summary-bottom">
                <h4>Total: <span id="totlaamount" class="totlaamount">Tk {{$total}}.00</span>
                </h4>
                @foreach($items as $data)
                @php
                $ptol=DB::table('products')->where('id','=',$data->associatedModel->id)->get();
                $ptols = $ptol->sum('par_price');

                @endphp
                @endforeach
                @if($bkashpar == 1)
                <div class="mt-2" id="bkashpars" style=" background: rgb(243 243 243); color: red; padding: 20px; border-radius: 5px; margin-bottom: 10px;">
                    আপনাকে {{$ptols}} টাকা এডভান্স পেমেন্ট করতে হবে।
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
</div>
</div>
</div>
@else
<div class="checkout-area pt-30 pb-30 ">
    <div class="custom-container bg-white py-4">
        <div class="row ">
            <div class="col-md-12 text-center p-4">
                @include('layouts.notification')
                <img src="{{URL::to('')}}/{{$setting->checkout_image}}" alt="" class="responsive">
                <h3 class="p-4">{!!$setting->checkout_text!!}</h3>
                <a href="@if($setting->checkout_link == null) {{url('/shop')}} @else {{$setting->checkout_link}} @endif" class="btn btn-success">শপিং করুন</a>
            </div>
        </div>
    </div>
</div>
@endif

@endsection
@push('styles')
<style>
    .border-new {
        border-radius: 10px;
    }

    input {
        border: 2px solid #e6e4e4;
        border-radius: 4px;
        padding-left: 8px;
    }

    input.form-control {
        background: #white !important;
        border-radius: 3px;
    }

    textarea.form-control {
        background: white !important;
        border-radius: 3px;
    }

    select#customerShipping {
        background: white !important;
        border-radius: 3px;
        color: #71777c;
    }

    select#states {
        background: white !important;
        border-radius: 3px;
        color: #71777c;
    }

    .paym {
        cursor: pointer;
        background: lightgray;
        border-radius: 5px;
        padding: 8px 8px;
        color: #706e6e;
        margin-left: -20px;
    }

    .activepay {
        border: 1px solid #fc8934;
        color: black;
    }

    .form-check-inline {
        margin-right: 2px;
    }

    @media (max-width: 1200px) {
        .code {
            width: 70% !important;
        }
    }

</style>

@endpush
@push('scripts')

<script>
    // Fetch user's IP address using a third-party API
    fetch('https://api.ipify.org?format=json', {
            headers: {
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            document.getElementById('ip_address').value = data.ip;
        })
        .catch(error => {
            console.error('Error fetching IP address:', error);
        });

</script>

<script>
    $('.btnclose').on('click', function(e) {
        $('.tm-demo-options-wrapper').toggleClass('demo-open');
    });
    $('.paym').on('click', function(e) {
        $('.paym').removeClass('activepay');
        $(this).addClass('activepay');
        var mehod = $(this).data('method');
        if (mehod == 'cod') {
            $('#cashtext').show();
            $('#bkashpars').hide();
        } else if (mehod == 'bkashpar') {
            $('#bkashpars').show();
            $('#cashtext').hide();
        } else {
            $('#cashtext').hide();
            $('#bkashpars').hide();
        }
        shipping()
        shippincharge()
    });

   $('.pluscart').on('click', function(e) {
    var id = $(this).data('id');
    var hudeqnt = '.quantitycart'+id;
    var qant = $('.quantitycart'+id).val();
    var newqant = parseInt(qant)+1;
    
    var url = '{{url('/add-quantity/')}}';
    $.ajax({
        url:url,
        type: "POST",
        data: {
            id: id,
            token: "{{ csrf_token() }}",
            "_token": "{{ csrf_token() }}",
        },
        success: function(response){
            $(hudeqnt).val(newqant);
            $('.totalamount').text(response);
            let cost = parseFloat( $('#customerShipping').find('option:selected').val() ) || 0;
            var subtotal = parseInt($('.totalamount').text());
            let total = (subtotal + cost).toFixed(2);
            $('.totlaamount').text('Tk '+total);
            shipping()
            shippincharge()
        }
    })
    
});


    function shipping() {
        let cost = parseFloat($('#couponprice').text()) || 0;
        var subtotal = parseInt($('.totalamount').text());
        let total = (subtotal - cost).toFixed(2);
        $('.totlaamount').text('Tk ' + total);
    }

    function shippincharge() {
        let cost = parseFloat($('#couponprice').text()) || 0;
        let shipprice = parseFloat($('#shipprice').text()) || 0;
        var subtotal = parseInt($('.totalamount').text());
        let total = (subtotal + shipprice - cost).toFixed(2);
        $('.totlaamount').text('Tk ' + total);
    }


   $('.minuscart').on('click', function(e) {
    var id = $(this).data('id');
    var hudeqnt = '.quantitycart'+id;
    var qant = $('.quantitycart'+id).val();
    var newqant = parseInt(qant)-1;
    if (newqant > 0) {
        var url = '{{url('/remove-quantity/')}}';
        $.ajax({
            url:url,
            type: "POST",
            data: {
                id: id,
                token: "{{ csrf_token() }}",
                "_token": "{{ csrf_token() }}",
            },
            success: function(response){
                $(hudeqnt).val(newqant);
                $('.totalamount').text(response);
                let cost = parseFloat( $('#customerShipping').find('option:selected').val() ) || 0;
                var subtotal = parseInt($('.totalamount').text());
                let total = (subtotal + cost).toFixed(2);
                $('.totlaamount').text('Tk '+total);
                shipping()
                shippincharge()
            }
        })
    }

});

   $('.deletecart').on('click', function(e) {
    var id = $(this).data('id');
    var hudeqnt = '#deletecart'+id;

    var url = '{{url('/delete-quantity/')}}';
    $.ajax({
        url:url,
        type: "POST",
        data: {
            id: id,
            token: "{{ csrf_token() }}",
            "_token": "{{ csrf_token() }}",
        },
        success: function(response){
            $(hudeqnt).empty();
            $('.totalamount').text(response.cartCollection);
            let cost = parseFloat( $('#customerShipping').find('option:selected').val() ) || 0;
            var subtotal = response.cartCollection;
            let total = parseFloat(subtotal)+parseFloat(cost);
            $('.totlaamount').text('Tk '+total.toFixed(2));
            $('.pro-count').text(response.cartCount);
            location.reload();
            shipping()
            shippincharge()
        }
    })

});

    $('#customerShipping').change(function() {
        let cost = parseFloat($(this).find('option:selected').val()) || 0;
        let getcity = $(this).find('option:selected').data('id');
        var subtotal = parseInt($('.totalamount').text());
        var couponprice = parseInt($('#couponprice').text());
        let total = parseFloat(subtotal + cost - couponprice).toFixed(2);
        $('#shipprice').text('' + cost);
        $('#city').val(getcity);
        $('.totlaamount').text('Tk ' + total);
        shipping()
        shippincharge()
    });


    $('#states').change(function() {
        let state = $(this).find('option:selected').val();
        var url = '{{url(' / getcity / ')}}';
        $.ajax({
            url: url
            , type: "POST"
            , data: {
                state: state
                , token: "{{ csrf_token() }}"
                , "_token": "{{ csrf_token() }}"
            , }
            , success: function(response) {
                $('#customerShipping').empty();
                $('#customerShipping').append('<option value="0" data-id="0">Select City</option>');

                for (let index = 0; index < response.length; index++) {
                    const element = response[index];
                    $('#customerShipping').append('<option value="' + element.price + '" data-id="' + element.id + '">' + element.type + '</option>');
                }
                shipping()
                shippincharge()
            }
        })
    });
    $(document).ready(function() {
        // Show/hide transaction input field based on payment method
        $('input[name="payment_method"]').change(function() {
            var paymentMethod = $(this).val();
            if (paymentMethod == 'cod') {
                $('#cashtext').show();
                $('#banktext').hide();
                $('input[name="trxid"]').prop('required', true);
                shipping()
                shippincharge()
            } else if (paymentMethod == 'bank') {
                $('#cashtext').hide();
                $('#banktext').show();
                $('input[name="trxid"]').prop('required', false);
                shipping()
                shippincharge()
            } else {
                $('#cashtext').hide();
                $('#banktext').hide();
                $('input[name="trxid"]').prop('required', false);
                shipping()
                shippincharge()
            }
        });
    });

</script>

@endpush
