@extends('layouts.app')
@php
$setting=DB::table('settings')->first();
@endphp
@section('meta')
@if($data->meta != null)
{!!$data->meta !!}
@else
<title>{{$data->title}}</title>
@endif
@endsection
@section('content')
@php
$color=explode(',',$data->color);
@endphp
@php 
$date = \Carbon\Carbon::today();
$date = $date->format('l');
$review = \App\Models\ProductReview::where('product_id', $data->id)->where('status', 1)->get();
@endphp
<div class="product-details-area padding-30-row-col pt-lg-30 pb-lg-30">
   <div class="container">
      <div class="row">
         <div class="col-lg-12 col-md-12 col-12">
            <div class="product-details-wrap">
               <div class="product-details-wrap-top">
                  <div class="row">
                     <div class="col-lg-6 col-md-6 col-12">
    <div class="product-details-slider-wrap" style="padding: 10px;">
        <div class="swiper mySwiper2" style="--swiper-navigation-color: #fff; --swiper-pagination-color: #fff;">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <img role="presentation" id="mainImage" src="{{ URL::to('') }}{{ $data->photo }}" class="zoomImg rounded-20"/>
                    
                </div>
                @if(isset($data->gallery))
                    @foreach(explode(',', $data->gallery) as $photo)
                        <div class="swiper-slide">
                            <img src="{{ URL::to('') }}{{ $photo }}" class="rounded-20"/>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
        <div thumbsSlider="" class="swiper mySwiper" style="padding-top: 10px; padding-bottom: 0;">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <img src="{{ URL::to('') }}{{ $data->photo }}" class="rounded-5"/>
                </div>
                @if(isset($data->gallery))
                    @foreach(explode(',', $data->gallery) as $photo)
                        <div class="swiper-slide">
                            <img src="{{ URL::to('') }}{{ $photo }}" class="rounded-5"/>
                        </div>
                    @endforeach
                @endif
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>
    </div>
</div>
                     <div class="col-lg-6 col-md-6 col-12">
                        <div class="product-details-content pro-details-content-pl p-2 px-lg-4 " style="border-radius: 40px; margin-top: 5px;">
                           <h1 class="py-1 my-1">{{$data->title}}</h1>
                           <div class="pro-details-price-short-description m-0 py-1">
                              @if($date == "Friday" && $data->is_featured == 1)
                              <div class="pro-details-price">
                                 <span class="new-price mr-2">Price: {{$data->friday_sale}} Taka </span> @if($data->friday_sale < $data->offer_price)<del
                                    class="new-price">{{$data->offer_price}} Taka </del> @endif
                                 </del>
                              </div>
                              @else
                              <div class="pro-details-price">
                                 <span id="prices" class="new-price mr-2">Price: {{$data->offer_price}} Taka </span> @if($data->offer_price < $data->price)<del
                                    class="new-price">{{$data->price}} Taka </del> @endif
                                 </del>
                              </div>
                              @endif
                           </div>
                           <div class="pro-details-quality-stock-area my-1">
                              <div class="pro-details-stock">
                                 <span>Product Details : </span> <br>
                                 <div>{!!$data->summary!!}</div>
                              </div>
                           </div>
                           @if($data->stock > 0)
                           <div class="" id="myformm" style="border:1px solid #fc8934">
                              <input type='button' value='-' class='qtyminus minus base-color' field='quantity' />
                              <input type='text' readonly="readonly" name='quantity'  id="quantity" value='1' class='qty quantity' />
                              <input type='button' value='+' class='qtyplus plus base-color' field='quantity' />
                           </div>
                           <span>
                              <lavel class="badge" style="background:#A17868;">in stock</lavel>
                           </span>
                           <div></div>
                           @if(isset($data->color))
                           <div class="size_selector mb-3">
                              <div class="d-flex align-items-center">
                                 @php
                                 $color=explode(',',$data->color);
                                 @endphp
                                 Color: 
                                 @foreach($color as $key => $colorsasas)
                                 @if($loop->index % 2 != 0)
                                 <div class="single_size_opt">
                                    <input type="radio" hidden data-img="{{URL::to('')}}/{{$color[$loop->index]}}" name="color" class="size_inp" value="{{$color[$loop->index-1]}}" id="color{{$color[$loop->index-1]}}">
                                    <label for="color{{$color[$loop->index-1]}}" data-id="{{$color[$loop->index-1]}}" class="colorpanel"> {{$color[$loop->index-1]}}</label>
                                 </div>
                                 @endif
                                 @endforeach
                              </div>
                           </div>
                           @endif
                           @php
// Fetch size variations for the current product
$productSizeVariations = \App\Models\ProductSizeVariation::where('product_id', $data->id)->get();
@endphp
@if($productSizeVariations->isNotEmpty())
<div class="size_selector mb-3">
    
   <div class="d-flex align-items-center">
      Size:
      @foreach ($productSizeVariations as $variation)
      <div class="single_size_opt">
         <input type="radio" hidden data-img="{{URL::to('')}}/{{ $variation->sizeimage }}" name="size" class="size_inp size_price" value="{{ $variation->size->id }}" data-price="{{ $variation->price }}" id="size-{{ $variation->id }}" {{ $variation->stock == 0 ? 'disabled' : '' }}>
         <label for="size-{{ $variation->id }}" class="sizepanel {{ $variation->stock == 0 ? 'out-of-stock' : '' }}" data-id="{{ $variation->id }}">
            {{ $variation->size->name }}
         </label>
      </div>
      @endforeach
   </div>
</div>
@endif

                           @php
                           // Fetch all liquid
                           $liquids = \App\Models\Liquid::all();
                           // Assuming $data represents the current product
                           // Fetch size variations for the current product
                           $liquidOilVariations = \App\Models\LiquidOilVariation::where('product_id', $data->id)->get();
                           @endphp
                           @if($liquidOilVariations->isNotEmpty())
                           <div class="size_selector mb-3">
                              <div class="d-flex align-items-center">
                                 Liquid:
                                 @foreach ($liquidOilVariations as $variation)
                                 <div class="single_size_opt">
                                    <input type="radio" hidden name="liquid" class="liquid_price" value="{{ $variation->liquid->id }}" data-prices="{{ $variation->price }}" id="liquid-{{ $variation->id }}">
                                    <label for="liquid-{{ $variation->id }}" class="liquidpanel">{{ $variation->liquid->name }}</label>
                                 </div>
                                 @endforeach
                              </div>
                           </div>
                           @endif
                           <div class="pro-details-action-wrap mb-2 d-block">
                              <div class="pro-details-add-to-cart">
                                 <button data-id="{{$data->id}}" id="buynowbutton" style="background-color: #0f134f ; color:{{$setting->buy_now_text_color}};margin-top: 3%;">
                                 অর্ডার করুন </button>
                                 <button data-id="{{$data->id}}" id="addtocart" style="background-color: #f85606; color:{{$setting->cart_text_color}};margin-top: 3%;">
                                 কার্টে যোগ করুন </button>
                                 @if($data->wholesale_price)
                                 <a href="https://wa.me/+88{{$setting->wholesale_number}}" target="_blank">
                                 <button style="background-color: #0d1185; color:white;margin-top: 3%;">
                                   হোলসেল ক্রয় </button>
                                 </a>
                                 @endif
                              </div>
                           </div>
                           <div class="pro-details-action-wrap mb-2 d-block">
                              <div class="pro-details-add-to-cart">
                                 <a href="https://wa.me/+88{{$setting->phone}}" target="_blank">
                                 <button style="background-color: #26c02c; color:white;margin-top: 3%;">
                                 <i class="fa-brands fa-whatsapp" style="color: white;"></i>  হোয়াটসঅ্যাপ অর্ডার
                                 </button>
                                 </a>
                                 <a href="tel:+88{{$setting->phone}}" target="_blank">
                                 <button style="background-color: #fc8934; color:white;margin-top: 3%;">
                                 <i class="fa-solid fa-phone" style="color: #ffffff;"></i>{{$setting->phone}}</button>
                                 </a>
                              </div>
                           </div>
                           @else
                           <lavel class="badge bg-danger" >Out of stock</lavel>
                           @endif
                           <!-- Hidden input field to store the selected price -->
                           <input type="hidden" id="sprice" name="sprice" value="">
                           <div class="mt-2" id="wholsaletext" style="display:none; background: #ef4848; color: white; padding: 20px; border-radius: 30px; margin-bottom: 10px;">
                              {!!$setting->product_summary!!}
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               @if($data->video != null)
               <div class="mt-4 bg-white p-4">
                  <div class="video-container">
                     <iframe src="{!!$data->video!!}" frameborder="0"  allow="accelerometer; autoplay; encrypted-media; gyroscope;"
                        allowfullscreen></iframe>
                  </div>
               </div>
               @endif
               <div class="row">
                  <div class="col-lg-12 mb-4">
                     <div class="mt-4 bg-white p-4">
                        @if(session('success'))
                        <div class="alert alert-success alert-dismissable fade show">
                           {{session('success')}}
                        </div>
                        <br><br>
                        @endif
                        @if(session('error'))
                        <div class="alert alert-danger alert-dismissable fade show" style="color:red; border:1px solid red;">
                           {{session('error')}}
                        </div>
                        <br><br>
                        @endif
                        <div class="tab-style-1 nav mb-35">
                           <a class="active" href="#product-details-1" data-toggle="tab"> Product Details </a>
                           <a href="#product-details-2" data-toggle="tab"> Review </a>
                        </div>
                        <div class="tab-content">
                           <div id="product-details-1" class="tab-pane active">
                              <div class="product-details-description ">
                                 <p>{!!$data->description!!}</p>
                              </div>
                           </div>
                           <div id="product-details-2" class="tab-pane">
                              <div class="pro-details-additional-information">
                                 <div class="additional-information">
                                    <form action="{{ route('reviewsubmit')}}" method="POST">
                                       @CSRF
                                       <input type="text" name="product_id" hidden value="{{$data->id}}">
                                       <p>Product review  </p>
                                       <div class="stars">
                                          <input class="form-check-input" id="star-5" type="radio" name="star" value="1" style="background: none; border: none;box-shadow:none;" />
                                          <label class="form-check-label paym active1 activepay" data-id="1" for="star-5"><span class="fa fa-star "></span></label>
                                          <input class="form-check-input" id="star-4" type="radio" name="star" value="2" style="background: none; border: none;box-shadow:none;"/>
                                          <label class="form-check-label paym active2 activepay" data-id="2" for="star-4"><span class="fa fa-star "></span></label>
                                          <input class="form-check-input" id="star-3" type="radio" name="star" value="3" style="background: none; border: none;box-shadow:none;"/>
                                          <label class="form-check-label paym active3 activepay" data-id="3" for="star-3"><span class="fa fa-star "></span></label>
                                          <input class="form-check-input" id="star-2" type="radio" name="star" value="4" style="background: none; border: none;box-shadow:none;"/>
                                          <label class="form-check-label paym active4 activepay" data-id="4" for="star-2"><span class="fa fa-star "></span></label>
                                          <input class="form-check-input" id="star-1" type="radio" checked name="star" value="5" style="background: none; border: none;box-shadow:none;"/>
                                          <label class="form-check-label paym active5 activepay" checked data-id="5" for="star-1"><span class="fa fa-star "></span></label>
                                       </div>
                                       <br>
                                       @error('star')
                                       <span class="text-danger">You didn't select review rating </span>
                                       @enderror
                                       <input type="number" class="form-control" required name="user_id" placeholder="Your phone number" ><br>
                                       @error('user_id')
                                       <span class="text-danger">Your phone number must be 11 digits long</span>
                                       @enderror
                                       <textarea type="text" name="review" required placeholder="Your review"></textarea>
                                       @error('review')
                                       <span class="text-danger">You have not written any reviews</span>
                                       @enderror
                                       <button class="btn btn-success base-color" type="submit" style="margin: 0 auto; width: auto; border-color: lightgray; color: white!important;">Review</button>
                                    </form>
                                    @if(isset($review))
                                    @foreach($review as $svxzcv)
                                    <br>
                                    <div class="row">
                                       <div class="col-12">
                                          <div class="review">
                                             @if($svxzcv->rate == 0)
                                             <div class="stars">
                                                <span class="fa fa-star "></span>
                                                <span class="fa fa-star "></span>
                                                <span class="fa fa-star "></span>
                                                <span class="fa fa-star "></span>
                                                <span class="fa fa-star"></span>
                                             </div>
                                             @endif
                                             @if($svxzcv->rate == 1)
                                             <div class="stars">
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star "></span>
                                                <span class="fa fa-star "></span>
                                                <span class="fa fa-star "></span>
                                                <span class="fa fa-star"></span>
                                             </div>
                                             @endif
                                             @if($svxzcv->rate == 2)
                                             <div class="stars">
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star "></span>
                                                <span class="fa fa-star "></span>
                                                <span class="fa fa-star"></span>
                                             </div>
                                             @endif
                                             @if($svxzcv->rate == 3)
                                             <div class="stars">
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star "></span>
                                                <span class="fa fa-star"></span>
                                             </div>
                                             @endif
                                             @if($svxzcv->rate == 4)
                                             <div class="stars">
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star "></span>
                                             </div>
                                             @endif
                                             @if($svxzcv->rate == 5)
                                             <div class="stars">
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star marked"></span>
                                                <span class="fa fa-star marked"></span>
                                             </div>
                                             @endif
                                             <div class="comment">
                                                <p>{{$svxzcv->review}}</p>
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                                    @endforeach
                                    @endif
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="col-12 col-mb-6">
                     @if(isset($related))
                     <div class="product-area pt-20 pb-20">
                        <div class="container">
                           <div class="section-title-btn-wrap st-btn-wrap-xs-center wow tmFadeInUp mb-20" >
                              <div class="section-title-1 category-base-color section-title-hm2" style=" padding: 20px; border-radius: 3px; width: 100%;">
                                 <h2 class="text-black text-center">Suggested Products</h2>
                              </div>
                           </div>
                           <div class="row row-cols-2 row-cols-lg-5 g-2 g-lg-3"style="margin-right: -7px;margin-left: -7px;">
                              @foreach($related as $row)
                              <div class="col">
                                 <div class="single-product-wrap mb-20 wow tmFadeInUp bg-white shadow-sm">
                                    <div class="product-img-action-wrap mb-10">
                                       <div class="product-img product-img-zoom">
                                          <a href="{{route('product.view',$row->slug)}}">
                                          <img class="default-img" loading="lazy"
                                             src="{{URL::to('')}}/{{$row->photo}}"
                                             data-src="{{URL::to('')}}/{{$row->photo}}"
                                             alt="">
                                          </a>
                                       </div>
                                       @if($row->discount >0)
                                       <div class="product-badges product-badges-position product-badges-mrg"><span
                                          class="red">-{{$row->discount}}
                                          %</span>
                                       </div>
                                       @endif
                                    </div>
                                    <div class="product-content-wrap px-2 pt-0 pb-2 px-2 pt-0 pb-2">
                                       <h2><a href="{{route('product.view',$row->slug)}}">{{$row->title}}</a></h2>
                                       <div class="product-price">
                                          <span class="new-price mr-2"> ৳ {{$row->offer_price}}</span> @if($row->offer_price < $row->price)<span class="old-price">{{$row->price}}</span> @endif
                                          @if($row->type=="single")
                                          @if($row->stock > 0)
                                          <div class="d-flex justify-content-center mb-2 mt-3 your_choice">
                                             <a href="javascript:void(0);" class="button rounded-4 text-center text-rubik text-orange-carrot-orange homebuynowb" data-id="{{ $row->id }}"><i class="fas fa-shopping-cart"></i> Order Now</a>
                                          </div>
                                          @else
                                          <label class="badge bg-danger">Out of stock</label>
                                          @endif
                                          @else
                                          @if($row->stock > 0)
                                          <div class="d-flex justify-content-center mb-2 mt-3 your_choice">
                                             <a href="{{route('product.view',$row->slug)}}" class="button rounded-4 text-center text-rubik text-orange-carrot-orange homebuynowbv" data-id="{{ $row->id }}" data-name="{{ $row->title }}"><i class="fas fa-shopping-cart"></i> অর্ডার করুন</a>
                                          </div>
                                          @else
                                          <label class="badge bg-danger">Out of stock</label>
                                          @endif
                                          @endif
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              @endforeach
                           </div>
                        </div>
                     </div>
                     @endif
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection
@push('styles')
{!!$data->meta!!}
<link
   rel="stylesheet"
   href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css"
   />
<script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
<style>
.sizepanel {
    cursor: pointer; /* Ensure the pointer cursor is visible for available sizes */
}

.sizepanel.out-of-stock {
    text-decoration: line-through;
    color: gray;
    position: relative;
    pointer-events: none; /* Prevent interaction with out-of-stock items */
}

.sizepanel.out-of-stock:hover::after {
    content: "Out of Stock";
    position: absolute;
    top: -1.5em; /* Adjust positioning as needed */
    left: 0;
    background-color: rgba(0, 0, 0, 0.75);
    color: white;
    padding: 2px 5px;
    border-radius: 3px;
    font-size: 0.75em;
    white-space: nowrap;
    pointer-events: none; /* Ensure hover effect is only for display */
}
   .paym{
   cursor: pointer;color: grey;
   }
   .swiper {
   width: 100%;
   height: 100%;
   }
   .swiper-slide {
   text-align: center;
   font-size: 18px;
   display: flex;
   justify-content: center;
   align-items: center;
   }
   .swiper-slide img {
   display: block;
   width: 100%;
   height: 100%;
   object-fit: cover;
   }
   .swiper {
   width: 100%;
   height: 300px;
   margin-left: auto;
   margin-right: auto;
   }
   .swiper-slide {
   background-size: cover;
   background-position: center;
   }
   .mySwiper2 {
   height: 80%;
   width: 100%;
   }
   .mySwiper {
   height: 20%;
   box-sizing: border-box;
   padding: 10px 0;
   }
   .mySwiper .swiper-slide {
   width: 25%;
   height: 100%;
   opacity: 0.4;
   }
   .mySwiper .swiper-slide-thumb-active {
   opacity: 1;
   }
   .marked{
   color:orange;
   }
   
   .video-container {
   position: relative;
   padding-bottom: 56.25%;
   }
   input.form-control {
   }
   textarea {
   background: white !important;
   border-radius: 3px !important;
   }
   .activepay{
   color:orange;
   }
   .video-container iframe {
   position: absolute;
   top: 0;
   left: 0;
   width: 100%;
   height: 100%;
   }
   #product-details-1 img {
   width: 100%;
   object-fit: cover;
   }
   .pro-details-action-wrap button {
   transition: all 0.3s ease-in-out;
   }
   .pro-details-action-wrap button:hover {
   transform: scale(1.1);
   box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
   }
</style>
@endpush
@push('scripts')
<script>
   $(document).ready(function() {
      @php
                                        $cate=explode(',',$data->cat_id);
                                        @endphp
                                        @foreach($cate as $item)
                                        @php
                                        $category=DB::table('categories')->where('id','=',$item)->first();
                                        @endphp                         
       // Get the current date
       var currentDate = new Date();
        // Array of weekday names
        var daysOfWeek = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        // Get the day of the week (0 for Sunday, 1 for Monday, ..., 6 for Saturday)
        var dayIndex = currentDate.getDay();
        // Get the actual day name using the day index
        var currentDay = daysOfWeek[dayIndex];
        // Array of month names
        var monthNames = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
   
        // Get the name of the current month
        var currentMonthIndex = currentDate.getMonth();
        var currentMonthName = monthNames[currentMonthIndex];
       
       fbq('track', 'ViewContent', {
           value: {{$data->offer_price}},
           currency: 'BDT',
           product_price: '{{$data->offer_price}}',
           content_category: '{{$category->title}}',
           category_name: '{{$category->title}}',
           content_ids: '{{$data->id}}',
           content_name: '{{$data->title}}',
           content_type: 'product',
           content_url: window.location.href,
           landing_page: window.location.href,
           post_id: '{{$data->id}}',
           post_type: 'product',
           user_role: 'user',
           domain: window.location.hostname,
           page_title: document.title,
           event_url: window.location.href,
           event_source_url: window.location.href,
           event_day: currentDay,
           event_month: currentMonthName,
           event_time: Math.floor(Date.now() / 1000),
           contact: 'everrivo.com'
       });
       @endforeach
   });
</script>
<script type="text/javascript">
   var button = document.getElementById('addtocart');
   button.addEventListener(
     'click', 
     function() { 
       @php
         $cate=explode(',',$data->cat_id);
       @endphp
       @foreach($cate as $item)
         @php
           $category=DB::table('categories')->where('id','=',$item)->first();
         @endphp    
         fbq('track', 'AddToCart', {
           content_name: '{{$data->title}}', 
           content_category: '{{$category->title}}',
           content_ids: ['{{$data->id}}'],
           content_type: 'product',
           content_url: window.location.href,
           domain: window.location.hostname,
           page_title: document.title,
           value: {{$data->offer_price}},
           event_source_url: window.location.href,
           currency: 'BDT',
           contact: 'everrivo.com'
           
         });  
       @endforeach        
     },
     false
   );
</script>
<script>
        document.addEventListener('DOMContentLoaded', function () {
            // Get all size labels
            const sizeLabels = document.querySelectorAll('.sizepanel');
            // Get the size image element
            const sizeImage = document.getElementById('sizeimage');

            sizeLabels.forEach(label => {
                label.addEventListener('click', function () {
                    // Get the corresponding radio button element
                    const radioInput = document.getElementById('size-' + this.getAttribute('data-id'));
                    // Get the image URL from data-img attribute
                    const imageUrl = radioInput.getAttribute('data-img');
                    // Update the src of the size image
                    sizeImage.src = imageUrl;
                });
            });
        });
    </script>
<script>
   $('.paym').on('click', function(e){
       $('.paym').removeClass('activepay');
       $(this).addClass('activepay');
       var data = $(this).data('id');
       if(data == 1){
           $('.paym').removeClass('activepay');
           $('.active1').addClass('activepay');
           
       }
       if(data == 2){
           $('.paym').removeClass('activepay');
           $('.active1').addClass('activepay');
           $('.active2').addClass('activepay');
           
       }
       if(data == 3){
           $('.paym').removeClass('activepay');
           $('.active1').addClass('activepay');
           $('.active2').addClass('activepay');
           $('.active3').addClass('activepay');
           
       }
       if(data == 4){
           $('.paym').removeClass('activepay');
           $('.active1').addClass('activepay');
           $('.active2').addClass('activepay');
           $('.active3').addClass('activepay');
           $('.active4').addClass('activepay');
           
       }
       if(data == 5){
           $('.paym').removeClass('activepay');
           $('.active1').addClass('activepay');
           $('.active2').addClass('activepay');
           $('.active3').addClass('activepay');
           $('.active4').addClass('activepay');
           $('.active5').addClass('activepay');
           
       }
   });
   
   
   $('#wholesale').on('click',function(){
       $('#wholsaletext').toggle();
   })
   $('.colorpanel').on('click', function(e) {
       $('.colorpanel').css("background", "none");
       $('.colorpanel').css("border", "1px solid #fc8934");
       $('.colorpanel').css("color", "black");
   
       $('.image').css("color", "black");
   
       var id = $(this).data('id');
       var hudeqnt = '#color'+id;
       var qant = $(hudeqnt).data('img');
       $('#image').attr("src",qant);
       $('#image').attr("data-src",qant);
       $('#imagepopup').attr("href",qant);
       
   
       $(this).css("background-color", "#fc8934");
       $(this).css("color", "white");
   });
   $('.colorpanel').on('click', function(e) {
       var id = $(this).data('id');
       var hudeqnt = '#'+id;
       $(hudeqnt).var('');
       console.log(id);
   
   });
   
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Prevent clicks on disabled radio buttons
    document.querySelectorAll('input[type=radio][disabled]').forEach(function(radio) {
        radio.addEventListener('click', function(e) {
            e.preventDefault();
        });
    });

    // Update color and border of the selected size panel
    $('.sizepanel').on('click', function(e) {
        if ($(this).hasClass('out-of-stock')) {
            e.preventDefault();
            return; // Prevent further processing for out-of-stock items
        }

        // Reset styles for all panels
        $('.sizepanel').css({
            "background": "none",
            "border": "1px solid #fc8934",
            "color": "black"
        });

        // Update the selected panel's styles
        $(this).css({
            "background-color": "#fc8934",
            "color": "white"
        });

        // Update image based on the selected panel
        var id = $(this).data('id');
        var hudeqnt = '#color'+id;
        var qant = $(hudeqnt).data('img');
        $('#image').attr("src", qant);
        $('#image').attr("data-src", qant);
        $('#imagepopup').attr("href", qant);
    });
});
</script>
<script>
    document.querySelectorAll('.colorpanel').forEach(item => {
        item.addEventListener('click', event => {
            const imageURL = event.target.previousElementSibling.dataset.img;
            document.querySelectorAll('#mainImage').forEach(image => image.src = imageURL);
            document.querySelectorAll('.mySwiper2 .swiper-slide img').forEach(image => image.src = imageURL);
        });
    });

    document.querySelectorAll('.mySwiper .swiper-slide img').forEach(item => {
        item.addEventListener('click', event => {
            const imageURL = event.target.src;
            document.querySelectorAll('.mySwiper2 .swiper-slide img').forEach(image => image.src = imageURL);
        });
    });
</script>
<script>
   // Add event listener to liquid radio buttons
   document.querySelectorAll('.liquid_price').forEach(function(radioButton) {
       radioButton.addEventListener('change', function(event) {
           // Get the selected liquid's price
           var selectedPrice = event.target.getAttribute('data-prices');
           
           
           // Update the displayed price
           var priceElement = document.getElementById('prices');
           if (priceElement) {
               priceElement.innerText = 'Price: ' + selectedPrice + ' Taka';
           }
           
           // Update the price attribute
           document.getElementById('prices').value = selectedPrice;
       });
   });
</script>
<script>
   // Add event listener to size radio buttons
   document.querySelectorAll('.size_price').forEach(function(radioButton) {
       radioButton.addEventListener('change', function(event) {
           // Get the selected size's price
           var selectedPrice = event.target.getAttribute('data-price');
           // Update the displayed price
           document.getElementById('prices').innerText = 'Price: ' + selectedPrice + ' Taka';
           // Update the price attribute
           document.getElementById('sprice').value = selectedPrice;
       });
   });
</script>
<script>
   $('#addtocart').click(function(e) {
       var id = $(this).data('id');
       var quantity = parseInt($('#quantity').val());
       var sprice = $('#sprice').val(); // Get the sprice value
       var prices = $('#prices').val(); // Get the lprice value
   
       // Check if the product has colors and if a color is selected
       @if(isset($data->color))
           var color = $('input[name="color"]:checked').val();
           if(color == null) {
               showErrorMessage('Please select color!');
               return;
           }
       @endif
   
       // Check if the product has sizes and if a size is selected
       @if($data->stock > 0)
       @if($productSizeVariations->isNotEmpty())
           var size = $('input[name="size"]:checked').val();
           if(size == null) {
               showErrorMessage('Please select Size!');
               return;
           }
       @endif
   
       // Check if the product has liquids and if a size is selected
       @if($liquidOilVariations->isNotEmpty())
           var liquid = $('input[name="liquid"]:checked').val();
           if(liquid == null) {
               showErrorMessage('Please select liquid!');
               return;
           }
       @endif
       @endif
   
       // Perform the AJAX request to add the product to the cart
       var url = '{{ url('/add-to-cart/') }}';
       $.ajax({
           url: url,
           type: "POST",
           data: {
               id: id,
               quantity: quantity,
               @if(isset($data->color))
                   color: color,
               @endif
   
               @if($productSizeVariations->isNotEmpty())
               size: size,
               @endif
               sprice: sprice,  
               prices: prices,
   
               token: "{{ csrf_token() }}",
               "_token": "{{ csrf_token() }}",
           },
           success: function(response) {
               console.log(response);
               Swal.fire({
                   position: 'center',
                   icon: 'success',
                   title: 'Add to cart successfully!',
                   showConfirmButton: false,
                   timer: 1000
               });
   
               $('.pro-count').text(response);
               $("#cartdata").empty();
               $.ajax({
                   url: '{{ route('cart.view') }}',
                   datatype: "html",
                   method: "GET",
               }).done(function(response) {
                   if (response.length == 0) {
                       return;
                   }
                   $("#cartdata").append(response);
               });
           }
       });
   });
   
   function showErrorMessage(message) {
       Swal.fire({
           position: 'center',
           icon: 'error',
           title: message,
           showConfirmButton: false,
           timer: 1000
       });
   }
</script>
<script>
   $('#buynowbutton').click(function(e) {
   var id = $(this).data('id');
   var quantity = parseInt($('#quantity').val());
   var sprice = $('#sprice').val(); // Get the sprice value
   var prices = $('#prices').val(); // Get the prices value
   
   // Check if the product has colors and if a color is selected
   @if(isset($data->color))
       var color = $('input[name="color"]:checked').val();
       if(color == null) {
           showErrorMessage('Please select color!');
           return;
       }
   @endif
   @if($data->stock > 0)
   // Check if the product has sizes and if a size is selected
   @if($productSizeVariations->isNotEmpty())
       var size = $('input[name="size"]:checked').val();
       if(size == null) {
           showErrorMessage('Please select Size!');
           return;
       }
   @endif
   
   // Check if the product has sizes and if a size is selected
   @if($liquidOilVariations->isNotEmpty())
       var liquid = $('input[name="liquid"]:checked').val();
       if(liquid == null) {
           showErrorMessage('Please select Liquid!');
           return;
       }
   @endif
   @endif
   
   // Perform the AJAX request to add the product to the cart
   var url = '{{ url('/add-to-cart/') }}';
   $.ajax({
       url: url,
       type: "POST",
       data: {
           id: id,
           quantity: quantity,
           @if(isset($data->color))
               color: color,
           @endif
           @if($data->stock > 0)
           @if($productSizeVariations->isNotEmpty())
               size: size,
           @endif
           sprice: sprice,
   
           @if($liquidOilVariations->isNotEmpty())
               liquid: liquid,
           @endif
           @endif
           prices: prices,
   
           token: "{{ csrf_token() }}",
           "_token": "{{ csrf_token() }}",
       },
       success: function(response) {
           console.log(response);
           Swal.fire({
               position: 'center',
               icon: 'success',
               title: 'Product added successfully!',
               showConfirmButton: false,
               timer: 1000
           });
   
           $('.pro-count').text(response);
           $("#cartdata").empty();
           $.ajax({
               url: '{{ route('cart.view') }}',
               datatype: "html",
               method: "GET",
           }).done(function(response) {
               if (response.length == 0) {
                   return;
               }
               $("#cartdata").append(response);
           });
           
           // Redirect to the checkout page
               $(location).prop('href', '{{url('/checkout')}}');
       }
   });
   });
   
   function showErrorMessage(message) {
   Swal.fire({
       position: 'center',
       icon: 'error',
       title: message,
       showConfirmButton: false,
       timer: 1000
   });
   }
</script>
<script>
   var swiper = new Swiper(".mySwiper", {
     spaceBetween: 10,
     slidesPerView: 4,
     freeMode: true,
     watchSlidesProgress: true,
   });
   var swiper2 = new Swiper(".mySwiper2", {
     spaceBetween: 10,
     navigation: {
       nextEl: ".swiper-button-next",
       prevEl: ".swiper-button-prev",
     },
     thumbs: {
       swiper: swiper,
     },
   });
   document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('input[type=radio][disabled]').forEach(function(radio) {
        radio.addEventListener('click', function(e) {
            e.preventDefault();
        });
    });
});

</script>

@endpush