@extends('layouts.app')

@section('content')
@php
$setting=DB::table('settings')->first();
@endphp
<div class="checkout-area pt-30 pb-30 ">
    <div class="container bg-white py-4">
        <div class="row " style="    padding: 20px;">
            <div class="col-md-3 col-sm-12 col-xl-3 col-lg-3 p-4"
                style="height: fit-content;border:1px solid {{$setting->header_color}};border-radius: 30px;">
                <div class="text-center">
                    @if(Auth()->user()->photo == null)
                    <img src="{{URL::to('')}}/public/assets/blank-profile-picture-973460_960_720.webp" alt=""
                        style="width: 50px; height: 50px; border-radius: 50%;">
                    @else
                    <img src="{{URL::to('')}}/public/storage/user/{{Auth()->user()->photo}}" alt=""
                        style="width: 50px; height: 50px; border-radius: 50%;">
                    @endif
                </div><br>
                <h2 class="text-center">{{Auth()->user()->name}}</h2><br>
                <ul style="padding: 25px;">
                    <li><a href="{{route('user')}}">Dashboard </a></li>
                    <li><a href="{{ route('user.order')}}">Order List</a></li>
                    <li><a href="{{ route('user.payreq')}}">Payment Request </a></li>
                    <li><a href="{{ route('user.setting')}}">Settings </a></li>
                    <li><a href="{{ route('user.password')}}">Password </a></li>
                    <li> <a href="#" onclick="event.preventDefault();
                              document.getElementById('logout-form').submit();">Logout </a>
                        <form id="logout-form" action="{{route('logout')}}" method="POST" style="display: none;">
                            @csrf
                        </form>
                    </li>

                </ul>
            </div>
            <div class="col-md-9 col-sm-12 col-xl-9 col-lg-9 ">
                @if(session('success'))
                <div class="alert alert-success alert-dismissable fade show">
                    {{session('success')}}
                </div>
                <br><br>
                @endif


                @if(session('error'))
                <div class="alert alert-danger alert-dismissable fade show" style="color:red; border:1px solid red;">
                    {{session('error')}}
                </div><br><br>
                @endif
                <h3 class="text-center p-4">Payment Request List</h3><br>
                <div class="table-responsive">
                    <table class="table  datanew ">
                        <tr>
                            <th>Order ID</th>
                            <th>Payment Request For</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Payment Link</th>
                        </tr>
                        @if(count($payreq)>0)
                        @foreach($payreq as $product)
                        @foreach($product as $xccvbxc)
                        <tr>
                            <th>{{$setting->order_prefix}}{{$xccvbxc->order_id}}</th>
                            <th>{{$xccvbxc->payment_for}}</th>
                            <th>{{$xccvbxc->amount}}</th>
                            <th>{{$xccvbxc->status}}</th>
                            <th>@if($xccvbxc->status == 'Unpaid')<a href="{{ route('paymentreqb', $xccvbxc->id)}}"
                                    class="btn-sm btn-outline-success">Make Payment</a> @endif</th>
                        </tr>
                        @endforeach
                        @endforeach
                        @else
                        <tr>
                            <th class="text-center" colspan="5">No payment request yet!!!</th>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
@endpush
@push('styles')
<style>
input.form-control {
    background: lightgray;
    border-radius: 20px;
}

.active {
    font-weight: bold;
    color: green;
}
</style>
<style>
table {
    font-family: arial, sans-serif;
    border-collapse: collapse;
    width: 100%;
}

td,
th {
    border: 1px solid #dddddd;
    text-align: left;
    padding: 8px;
}

tr:nth-child(even) {
    background-color: #f3f3f3;
}
</style>
@endpush