@extends('layouts.app')

@section('content')
@php
$setting=DB::table('settings')->first();
@endphp
<div class="checkout-area pt-30 pb-30 ">
    <div class="container bg-white py-4">
        <div class="row " style="    padding: 20px;">
            <div class="col-md-3 col-sm-12 col-xl-3 col-lg-3 p-4"
                style="height: fit-content;border:1px solid {{$setting->header_color}};border-radius: 30px;">
                <div class="text-center">
                    @if(Auth()->user()->photo == null)
                    <img src="{{URL::to('')}}/public/assets/blank-profile-picture-973460_960_720.webp" alt=""
                        style="width: 50px; height: 50px; border-radius: 50%;">
                    @else
                    <img src="{{URL::to('')}}/public/storage/user/{{Auth()->user()->photo}}" alt=""
                        style="width: 50px; height: 50px; border-radius: 50%;">
                    @endif
                </div><br>
                <h2 class="text-center">{{Auth()->user()->name}}</h2><br>
                <ul style="padding: 25px;">
                    <li><a href="{{route('user')}}">Dashboard </a></li>
                    <li><a href="{{ route('user.order')}}">Order List</a></li>
                    <li><a href="{{ route('user.payreq')}}">Payment Request </a></li>
                    <li><a href="{{ route('user.setting')}}">Settings </a></li>
                    <li><a href="{{ route('user.password')}}">Password </a></li>
                    <li> <a href="#" onclick="event.preventDefault();
                              document.getElementById('logout-form').submit();">Logout </a>
                        <form id="logout-form" action="{{route('logout')}}" method="POST" style="display: none;">
                            @csrf
                        </form>
                    </li>
                </ul>
            </div>
            <div class="col-md-9 col-sm-12 col-xl-9 col-lg-9 p-4">
                <h3 class="text-center">Settings</h3><br>
                <div class="col-12" style="margin: 0 auto;">
                    @include('backend.layouts.notification')
                </div>
                <div class="col-md-12 col-sm-12 col-xl-12 col-12" style="margin: 0 auto;">
                    <form action="{{ route('user.setting.update')}}" method="POST" enctype="multipart/form-data">
                        @CSRF
                        <div class="col-lg-12 mb-4">
                            <label for="">Profile Photo </label>
                            <input type="file" class="form-control " name="photo" placeholder="">
                            @error('photo')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="col-lg-12 mb-4">
                            <input type="text" value="{{$data->name}}" class="form-control " required="required"
                                name="name" required placeholder="Your full name">
                            @error('name')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="col-lg-12 mb-4">
                            <input type="email" value="{{$data->email}}" class="form-control " required="required"
                                name="email" required placeholder=" Your Email">
                            @error('email')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="col-lg-12 mb-4">
                            <input type="number" value="{{$data->phone}}" class="form-control " required="required"
                                name="phone" required placeholder="Your phone number">
                            @error('phone')
                            <span class="text-danger">{{$message}}</span>
                            @enderror
                        </div>

                        <div class="col-lg-12 mb-4">
                            <button type="submit" class="btn btn-success btn-block btn-lg"
                                style="border-radius: 20px; width: auto; border-color: #306448; background: #306448!important; color: white !important;">
                                Submit </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
@endpush
@push('styles')
<style>
input.form-control {
    background: lightgray;
    border-radius: 20px;
}
</style>
@endpush