<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Auth::routes();

Route::get('/', [App\Http\Controllers\FrontendController::class, 'index'])->name('home');
Route::get('/admin', [App\Http\Controllers\FrontendController::class, 'ssLogin'])->name('ssLogin');
Route::post('/adminLogin/submit', [App\Http\Controllers\FrontendController::class, 'adminLoginsubmit'])->name('adminLoginsubmit');
Route::post('/phoneLogin', [App\Http\Controllers\FrontendController::class, 'phoneLogin'])->name('phoneLogin');

// SSLCOMMERZ Start
Route::get('/example1', [App\Http\Controllers\SslCommerzPaymentController::class, 'exampleEasyCheckout']);
Route::get('/example2', [App\Http\Controllers\SslCommerzPaymentController::class, 'exampleHostedCheckout']);

Route::post('/pay', [App\Http\Controllers\SslCommerzPaymentController::class, 'index']);
Route::post('/pay-via-ajax', [App\Http\Controllers\SslCommerzPaymentController::class, 'payViaAjax']);

Route::post('/success', [App\Http\Controllers\SslCommerzPaymentController::class, 'success']);
Route::post('/fail', [App\Http\Controllers\SslCommerzPaymentController::class, 'fail']);
Route::post('/cancel', [App\Http\Controllers\SslCommerzPaymentController::class, 'cancel']);

Route::post('/ipn', [App\Http\Controllers\SslCommerzPaymentController::class, 'ipn']);

//uddoktapay
Route::get('uddoktapay', [App\Http\Controllers\UddoktapayController::class, 'show'])->name('uddoktapay.payment-form');
Route::post('uddoktapay', [App\Http\Controllers\UddoktapayController::class, 'pay'])->name('uddoktapay.pay');
Route::get('/uddoktasuccess/{id}', [App\Http\Controllers\UddoktapayController::class, 'success'])->name('uddoktapay.success');
Route::get('uddoktacancel', [App\Http\Controllers\UddoktapayController::class, 'cancel'])->name('uddoktapay.cancel');
Route::post('uddoktawebhook', [App\Http\Controllers\UddoktapayController::class, 'webhook'])->name('uddoktapay.webhook');

//Product Section
Route::get('product/{slug}', [App\Http\Controllers\FrontendController::class, 'productDetail'] )->name('product.view');
Route::get('/holy-friday-sales', [App\Http\Controllers\FrontendController::class, 'fridaysales'] )->name('fridaysales');
Route::get('/shop', [App\Http\Controllers\FrontendController::class, 'shop'] )->name('shop');
Route::post('/product/search', [App\Http\Controllers\FrontendController::class, 'productSearch'])->name('product.search');
Route::get('/category/{slug}', [App\Http\Controllers\FrontendController::class, 'productCat'])->name('product.category');
Route::get('/brand/{slug}', [App\Http\Controllers\FrontendController::class, 'productBr'])->name('product.brand');
Route::get('/checkout', [App\Http\Controllers\FrontendController::class, 'checkout'])->name('checkout');
Route::post('/order/place', [App\Http\Controllers\CartController::class, 'orderSubmit'])->name('order.submit');
Route::post('/coupon-remove', [App\Http\Controllers\CartController::class, 'remove'])->name('coupon-remove');

Route::get('/page/{slug}', [App\Http\Controllers\FrontendController::class, 'page'])->name('page.index');
Route::get('/landing/template/preview/1', [App\Http\Controllers\FrontendController::class, 'previewa'])->name('previewa.index');
Route::get('/landing/{slug}', [App\Http\Controllers\FrontendController::class, 'landing'])->name('landing.index');
Route::get('/order-tracking', [App\Http\Controllers\FrontendController::class, 'track'])->name('track.index');
Route::post('/order-tracking', [App\Http\Controllers\FrontendController::class, 'trackView'])->name('track.find');
Route::get('/order/invoice/{id}', [App\Http\Controllers\FrontendController::class, 'invoice'])->name('invoice.index');
Route::get('/order/invoice/download/{id}', [App\Http\Controllers\FrontendController::class, 'invoicedownload'])->name('invoice.download');
Route::get('cart/show', [App\Http\Controllers\FrontendController::class, 'getProduct'] )->name('getProduct');

Route::get('/carrier', [App\Http\Controllers\FrontendController::class, 'carrier'])->name('carrier1');
Route::get('/carrier/{slug}', [App\Http\Controllers\FrontendController::class, 'carrierView'])->name('carrierView');
Route::post('/review/submit', [App\Http\Controllers\FrontendController::class, 'reviewsubmit'])->name('reviewsubmit');
// Cart section
Route::get('/cart-view', [App\Http\Controllers\CartController::class, 'cartview'])->name('cart.view');
Route::post('/add-to-cart', [App\Http\Controllers\CartController::class, 'addToCart'])->name('cart.add');
Route::post('/add-quantity', [App\Http\Controllers\CartController::class, 'cartAdd'])->name('cart.add.quantity');
Route::post('/remove-quantity', [App\Http\Controllers\CartController::class, 'cartRemove'])->name('cart.remove.quantity');
Route::post('/delete-quantity', [App\Http\Controllers\CartController::class, 'cartDelete'])->name('cart.delete.quantity');
Route::post('/coupon-store', [App\Http\Controllers\CartController::class, 'couponStore'])->name('coupon-store');
Route::post('/getcity', [App\Http\Controllers\CartController::class, 'getcity'])->name('getcity');

Route::get('/bkash/pay', [App\Http\Controllers\CheckoutURLController ::class, 'payment'])->name('url-pay');
Route::post('/bkash/create', [App\Http\Controllers\CheckoutURLController ::class, 'createPayment'])->name('url-create');
Route::get('/bkash/callback', [App\Http\Controllers\CheckoutURLController ::class, 'callback'])->name('url-callback');
Route::post('/bulk-status-change', [App\Http\Controllers\OrderController::class, 'bulkStatusChange'])->name('order.bulkStatusChange');


//Render-----------
Route::get('/get-banners', [App\Http\Controllers\RenderController::class,'getBanner'])->name('getBanner');
Route::get('/get-categories', [App\Http\Controllers\RenderController::class, 'getCategorie'])->name('getCategorie');


Route::group(['prefix'=>'/dashboard','middleware'=>['auth','Admin']],function(){
    Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('dashboard');
    Route::get('menu',[App\Http\Controllers\MenuController::class, 'index']);	
    Route::post('menuUpdateDynamic',[App\Http\Controllers\MenuController::class, 'menuUpdateDynamic'])->name('menus.category.create');	

    Route::get('/bulk-prints', [App\Http\Controllers\OrderController::class, 'bulkPrints'])->name('order.bulkPrints');
    Route::get('customer', [App\Http\Controllers\HomeController::class, 'customer'])->name('customer.index');
    Route::get('reviews', [App\Http\Controllers\HomeController::class, 'reviews'])->name('reviews.index');
    Route::get('reviews/active/{id}', [App\Http\Controllers\HomeController::class, 'reviewsactive'])->name('reviews.active');
    Route::post('reviews/delete/{id}', [App\Http\Controllers\HomeController::class, 'reviewsDelete'])->name('reviews.delete');
    Route::get('resellers', [App\Http\Controllers\HomeController::class, 'resellers'])->name('resellers.index');
    Route::get('resellers/read/{id}', [App\Http\Controllers\HomeController::class, 'resellersread'])->name('resellers.read');
    Route::get('resellers/delete/{id}', [App\Http\Controllers\HomeController::class, 'resellersdelete'])->name('resellers.delete');
    Route::get('notification/read/{id}', [App\Http\Controllers\HomeController::class, 'notificationread'])->name('notification.read');
    Route::get('notification/delete/{id}', [App\Http\Controllers\HomeController::class, 'notificationdelete'])->name('notification.delete');
    //Route::get('banner', [App\Http\Controllers\HomeController::class, 'banner'])->name('banner.index');
    //Route::PATCH('banner/update/{id}', [App\Http\Controllers\HomeController::class, 'update'])->name('banner.update');

    Route::get('general', [App\Http\Controllers\HomeController::class, 'general'])->name('general.index');
    Route::PATCH('general/update/{id}', [App\Http\Controllers\HomeController::class, 'generalUpdate'])->name('general.update');

    Route::get('website', [App\Http\Controllers\HomeController::class, 'website'])->name('website.index');
    Route::PATCH('website/update/{id}', [App\Http\Controllers\HomeController::class, 'websiteUpdate'])->name('website.update');

    Route::get('social', [App\Http\Controllers\HomeController::class, 'social'])->name('social.index');
    Route::PATCH('social/update/{id}', [App\Http\Controllers\HomeController::class, 'socialUpdate'])->name('social.update');

    Route::get('analytics', [App\Http\Controllers\HomeController::class, 'analytics'])->name('analytics.index');
    Route::PATCH('analytics/update/{id}', [App\Http\Controllers\HomeController::class, 'analyticsUpdate'])->name('analytics.update');

    Route::get('product-details', [App\Http\Controllers\HomeController::class, 'productview'])->name('productview.index');
    Route::PATCH('product-details/update/{id}', [App\Http\Controllers\HomeController::class, 'productviewUpdate'])->name('productview.update');

    Route::get('/media', [App\Http\Controllers\HomeController::class, 'media'])->name('media');
    Route::resource('product', App\Http\Controllers\ProductController::class);
    Route::get('product/active/{id}', [App\Http\Controllers\ProductController::class, 'active'])->name('product.active');
    Route::get('sale/pos/', [App\Http\Controllers\OrderController::class, 'pos'])->name('sale.pos');
    Route::get('product/deactive/{id}', [App\Http\Controllers\ProductController::class, 'deactive'])->name('product.deactive');
    Route::resource('category', App\Http\Controllers\CategoryController::class);
    Route::resource('size', App\Http\Controllers\SizeController::class);
    Route::resource('brand', App\Http\Controllers\BrandController::class);
    Route::resource('ipblock', App\Http\Controllers\IPBlockController::class);
    Route::resource('pages', App\Http\Controllers\PagesController::class);
    Route::resource('landings', App\Http\Controllers\LandingsController::class);
    Route::resource('career', App\Http\Controllers\CarriersController::class);
    Route::resource('state', App\Http\Controllers\StateController::class);
    Route::resource('shipping', App\Http\Controllers\ShippingController::class);
    Route::resource('coupon', App\Http\Controllers\CouponController::class);
    Route::resource('banners', App\Http\Controllers\BannersController::class);
    Route::resource('user', App\Http\Controllers\UserController::class);
    Route::resource('status', App\Http\Controllers\StatusController::class);
    Route::resource('order', App\Http\Controllers\OrderController::class);
    Route::resource('facebook', App\Http\Controllers\FacebookOrderController::class);
    Route::resource('whatsapp', App\Http\Controllers\WhatsappOrderController::class);
    Route::resource('outlet-order', App\Http\Controllers\OutletOrderController::class);
    Route::resource('delivery', App\Http\Controllers\DeliveryController::class);
    Route::resource('sms_template', App\Http\Controllers\SmsController::class);
    Route::resource('schedule', App\Http\Controllers\ScheduleController::class);
    Route::resource('expenses', App\Http\Controllers\ExpenseController::class);
    Route::resource('expenses', App\Http\Controllers\ExpenseController::class);
    Route::resource('suppliers', App\Http\Controllers\SupplierController::class);
    Route::resource('warehouses', App\Http\Controllers\WarehouseController::class);
    Route::resource('stocks', App\Http\Controllers\StockController::class);
    Route::resource('wholesale', App\Http\Controllers\WholesaleController::class);
    Route::post('/update-table', [App\Http\Controllers\OrderController::class, 'updateTable']);
    Route::get('status_wise_order', [App\Http\Controllers\OrderController::class, 'status_wise_order'])->name('status_wise_order');
    Route::post('expenses/search', [App\Http\Controllers\ExpenseController::class, 'expensesdate'])->name('expenses.search');
    Route::get('order/satus/{id}/{status}', [App\Http\Controllers\OrderController::class, 'status'])->name('sales.status');
    Route::get('order/facebook', [App\Http\Controllers\OrderController::class, 'facebook'])->name('sales.facebook');
    Route::get('order/whatsapp', [App\Http\Controllers\OrderController::class, 'whatsapp'])->name('sales.whatsapp');
    Route::get('order/outletorder', [App\Http\Controllers\OrderController::class, 'outletorder'])->name('sales.outletorder');
    Route::get('order/search/{status}', [App\Http\Controllers\OrderController::class, 'search'])->name('sales.search');
    Route::post('order/message/{id}', [App\Http\Controllers\OrderController::class, 'custommessage'])->name('custommessage');
    Route::post('order/payment-request/{id}', [App\Http\Controllers\OrderController::class, 'paymentrequest'])->name('paymentrequest');
    Route::get('order/payment-remove/{id}', [App\Http\Controllers\OrderController::class, 'paymentremove'])->name('paymentremove');
    Route::post('order-search', [App\Http\Controllers\OrderController::class, 'getsearch'])->name('sales.get');
    Route::get('order-download-pdf', [App\Http\Controllers\OrderController::class, 'downloadExcel'])->name('sales.downloadExcel');
    Route::post('order-download', [App\Http\Controllers\OrderController::class, 'downloadorder'])->name('sales.download.order');
    Route::get('report', [App\Http\Controllers\OrderController::class, 'report'])->name('report.index');
    Route::post('report/search', [App\Http\Controllers\OrderController::class, 'reportdate'])->name('report.date');
    Route::get('full-report', [App\Http\Controllers\OrderController::class, 'fullreport'])->name('fullreport.index');
    Route::post('full-report/search', [App\Http\Controllers\OrderController::class, 'fullreportdate'])->name('fullreport.date');
    Route::get('print/{id}', [App\Http\Controllers\OrderController::class, 'print'])->name('sales.print.order');
    Route::get('api/sms', [App\Http\Controllers\ApiController::class, 'sms'])->name('sms.index');
    Route::get('api/bkash', [App\Http\Controllers\ApiController::class, 'bkash'])->name('bkash.index');
    Route::get('api/bkash/refund', [App\Http\Controllers\ApiController::class, 'bkashnd'])->name('bkash.refund.index');
    Route::post('api/bkash/search', [App\Http\Controllers\ApiController::class, 'bkashsearch'])->name('bkash.search');
    Route::post('api/bkash/refund/submit', [App\Http\Controllers\ApiController::class, 'bkashrefund'])->name('bkash.refund');
    Route::post('api/bkash/refund/status', [App\Http\Controllers\ApiController::class, 'bkashrefundstatus'])->name('bkash.refund.status');
    Route::post('api/sms/submit', [App\Http\Controllers\ApiController::class, 'smsSubmit'])->name('sms.submit');
    Route::post('api/sms/test', [App\Http\Controllers\ApiController::class, 'smsTest'])->name('sms.test');
    Route::get('api/sms/status', [App\Http\Controllers\ApiController::class, 'smsstatus'])->name('sms.status');
    Route::get('/landing/template/', [App\Http\Controllers\LandingsController::class, 'template'])->name('template');
    Route::get('/landing/template/new/{slug}', [App\Http\Controllers\LandingsController::class, 'createNew'])->name('createNew');

    Route::delete('/size-variations/{id}', [App\Http\Controllers\ProductController::class, 'delete'])->name('size-variations.delete');
    
    
    #STEAD FAST API 
    Route::get('steadfast', [App\Http\Controllers\ApiController::class, 'steadfast'])->name('steadfast');
    Route::post('steadFastUpdate', [App\Http\Controllers\ApiController::class, 'steadFastUpdate'])->name('steadFastUpdate');
    Route::get('/get_balance', [App\Http\Controllers\ApiController::class, 'getBalance'])->name('getBalance');
    Route::get('/status_by_cid/{id}', [OrderController::class, 'getStatusByCid'])->name('status.by.cid');

    Route::post('sendSteadFast', [App\Http\Controllers\OrderController::class, 'sendSteadFast'])->name('sendSteadFast');

    #Redx api
    Route::get('redx', [App\Http\Controllers\ApiController::class, 'redx'])->name('redx');
    Route::post('redxUpdate', [App\Http\Controllers\ApiController::class, 'redxUpdate'])->name('redxUpdate');

    Route::post('createRedxParcel', [App\Http\Controllers\OrderController::class, 'createRedxParcel'])->name('createRedxParcel');

    #Pathao api
    Route::get('pathao', [App\Http\Controllers\ApiController::class, 'pathao'])->name('pathao');
    Route::post('pathaoUpdate', [App\Http\Controllers\ApiController::class, 'pathaoUpdate'])->name('pathaoUpdate');

    Route::post('OrderSendToPathao', [App\Http\Controllers\OrderController::class, 'OrderSendToPathao'])->name('OrderSendToPathao');
    Route::get('/zones-by-city/{city}', [App\Http\Controllers\OrderController::class, 'getPathaoZoneListByCity'])->name('zonesByCity');
    Route::get('/areas-by-zone/{zone}', [App\Http\Controllers\OrderController::class, 'getPathaoAreaListByZone'])->name('areasByZone');
    Route::get('/pathao/get-area-list/{zone}', [App\Http\Controllers\OrderController::class, 'getPathaoAreaListByZone'])->name('areasByid');

    Route::get('generate-access-token', [App\Http\Controllers\OrderController::class, 'viewAccessToken'])->name('viewAccessToken');
    Route::post('generate-access-token', [App\Http\Controllers\OrderController::class, 'generatePathaoAccessToken'])->name('generatePathaoAccessToken');
    Route::post('status-update', [App\Http\Controllers\OrderController::class, 'statusupdate'])->name('statusupdate');

   


});
Route::post('/landing/order/place', [App\Http\Controllers\FrontendController::class, 'landingorder'])->name('landing.lsubmit');
Route::get('/order-successfully-placed/{id}', [App\Http\Controllers\FrontendController::class, 'orderReceived'])->name('order.received');

Route::group(['prefix'=>'/user','middleware'=>['auth']],function(){
    Route::get('/otp', [App\Http\Controllers\ProfileController::class, 'otp'])->name('otp');
    Route::post('/otp/verify', [App\Http\Controllers\ProfileController::class, 'otpverify'])->name('otpverify');
});
Route::group(['prefix'=>'/user','middleware'=>['auth','User']],function(){
    Route::get('/', [App\Http\Controllers\ProfileController::class, 'index'])->name('user');
    Route::get('/order', [App\Http\Controllers\ProfileController::class, 'order'])->name('user.order');
    Route::get('/payment-bkash/{id}', [App\Http\Controllers\FrontendController::class, 'paymentreqcxv'])->name('paymentreqcxv');
    Route::get('/payment-request-bkash/{id}', [App\Http\Controllers\FrontendController::class, 'paymentreqb'])->name('paymentreqb');
    Route::get('/payment-request-success/{id}', [App\Http\Controllers\FrontendController::class, 'paymentsuccess'])->name('paymentsuccess');

    Route::get('/payment-request', [App\Http\Controllers\ProfileController::class, 'payreq'])->name('user.payreq');
    Route::get('/setting', [App\Http\Controllers\ProfileController::class, 'setting'])->name('user.setting');
    Route::post('/setting/update', [App\Http\Controllers\ProfileController::class, 'settingupdate'])->name('user.setting.update');
    Route::get('/password', [App\Http\Controllers\ProfileController::class, 'password'])->name('user.password');
    Route::post('/password/update', [App\Http\Controllers\ProfileController::class, 'passwordupdate'])->name('user.password.update');
});
Route::group(['prefix' => 'filemanager', 'middleware' => ['web', 'auth']], function () {
     \UniSharp\LaravelFilemanager\Lfm::routes();
 });
Route::get('/clear', function() {
    $exitCode = Artisan::call('config:clear');
    $exitCode = Artisan::call('cache:clear');
    $exitCode = Artisan::call('view:clear');
    $exitCode = Artisan::call('route:clear');
    $exitCode = Artisan::call('config:cache');
    return redirect()->route('home');
});

Route::get('/file', function () {
    Artisan::call('storage:link');
    return redirect()->route('home');
});
