

<?php $__env->startSection('content'); ?>
    <?php
        $generalSettings = App\Models\Setting::find(1); // Fetching general settings
    ?>

    <div class="content">
        <div class="page-header">
            <div class="page-title">
                <h4>Order Add</h4>
                <h6>Create New Order</h6>
            </div>
        </div>

        <form action="<?php echo e(route('order.store')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-12 col-sm-12 col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Customer Info</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <label>Customer Name</label>
                                        <input type="text" name="customerName" value="<?php echo e(old('customerName')); ?>" required>
                                        <?php $__errorArgs = ['customerName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <label>Customer Phone</label>
                                        <input type="text" name="customerPhone" value="<?php echo e(old('customerPhone')); ?>" required>
                                        <?php $__errorArgs = ['customerPhone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-sm-12 col-12">
                                    <div class="form-group">
                                        <label>Customer Address</label>
                                        <textarea name="customerAddress" rows="3"><?php echo e(old('customerAddress')); ?></textarea>
                                        <?php $__errorArgs = ['customerAddress'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-sm-12 col-12">
                                    <div class="form-group">
                                        <label>Customer Note</label>
                                        <textarea name="customerNote" rows="2"><?php echo e(old('customerNote')); ?></textarea>
                                        <?php $__errorArgs = ['customerNote'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 col-sm-12 col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Product Info</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-12 col-sm-12 col-12">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Action</th>
                                                <th>ID</th>
                                                <th>Product Name</th>
                                                <th>Color</th>
                                                <th>Size</th>
                                                <th>Quantity</th>
                                                <th>Price</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody class="productable">
                                            <!-- Product rows will be added dynamically -->
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-lg-12 col-sm-12 col-12">
    <div class="form-group">
        <label>Select Product</label>
        <select name="productselect" class="form-control productsc" id="productselect">
            <option value="">Select a Product</option>
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $sizeVariations = $product->sizeVariations;
                    $sizes = $sizeVariations->map(function ($variation) {
                        return ['name' => $variation->size->name, 'price' => $variation->price];
                    });
                ?>
                <option value="<?php echo e($product->id); ?>"
                        data-stock="<?php echo e($product->stock); ?>"
                        data-title="<?php echo e($product->title); ?>"
                        data-price="<?php echo e($product->offer_price); ?>"
                        data-color="<?php echo e($product->color); ?>"
                        data-sizes="<?php echo e(json_encode($sizes)); ?>"
                        data-photo="<?php echo e($product->photo); ?>">
                    <img src="<?php echo e(URL::to($product->photo)); ?>" alt="<?php echo e($product->title); ?>" style="width: 50px; height: auto;"> <?php echo e($product->title); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>

                                <!-- Additional fields for subtotals, shipping, discounts, payment, and total -->
                                <div class="col-lg-12 col-sm-12 col-12 row">
                                    <br>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Sub Total</label>
                                       <input type="text" class="form-control" value="0" readonly name="sub_total" id="sub_total" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Delivery</label>
                                       <input type="text" class="form-control" value="0" name="shipping_cost" id="shipping_cost" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Discount</label>
                                       <input type="text" class="form-control" value="0" name="discount" id="discount" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Payment</label>
                                       <input type="text" class="form-control" value="0" name="payment" id="payment" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Due</label>
                                       <input type="text" class="form-control" value="0" readonly name="collectables" id="collectables" style="width: 200px; margin-left: 20px;">
                                    </div>
                                    <div class="form-group" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                                       <label for="" style="margin-bottom:0;">Total</label>
                                       <input type="text" class="form-control" value="0" readonly name="total_amount" id="total_amount" style="width: 200px; margin-left: 20px;">
                                    </div>
                                 </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('.productsc').select2(); // Initialize select2 plugin

            $('#shipping_cost, #discount, #payment').on('input', function() {
                calculateTotal();
            });
        });

        let productCount = 0; 

        $('#productselect').on('change', function() {
            const selectedProduct = $(this).find('option:selected');
            const productId = selectedProduct.val();
            const productTitle = selectedProduct.data('title');
            const productColor = selectedProduct.data('color');
            const productSizes = selectedProduct.data('sizes');
            const productPrice = selectedProduct.data('price');
            const productStock = selectedProduct.data('stock');
            const productPhoto = selectedProduct.data('photo');

            productCount++;

            //const colors = productColor.split(',').map(color => `<option value="${color.trim()}">${color.trim()}</option>`).join('');
            // Generate options for color select
            const colors = productColor.split(',').filter((_, index) => index % 2 === 0).map(color => `<option value="${color.trim()}">${color.trim()}</option>`).join('');

            const sizes = productSizes.map(size => `<option value="${size.name}" data-price="${size.price}">${size.name}</option>`).join('');

            const newRow = `
                <tr>
                   <td><button class="btn btn-outline-primary remove-row" type="button">X</button></td>
                    <td>${productCount}<input type="hidden" name="order[${productCount}][product_id]" value="${productId}"></td>
                    <td><img src="<?php echo e(URL::to('')); ?>${productPhoto}" alt="product" style="width: 50px; height: auto;"> ${productTitle.substring(0, 25)}..</td>
                    <td><select name="order[${productCount}][color]" class="form-control">${colors}</select></td>
                    <td><select name="order[${productCount}][size]" class="form-control size-select">${sizes}</select></td>
                    <td><input type="number" class="form-control quantity" name="order[${productCount}][quantity]" data-id="${productId}" value="1" style="width: 80px;"></td>
                    <td><span class="price">${productPrice}</span><input type="hidden" name="order[${productCount}][price]" value="${productPrice}" class="price-input" id="price${productId}"></td>
                    <td><p class="subtotal" id="subtotal${productId}">${productPrice}</p></td>
                    
                </tr>
            `;

            $('.productable').append(newRow);

            calculateTotal();

            $('.size-select').on('change', function() {
                const selectedSize = $(this).find('option:selected');
                const newPrice = selectedSize.data('price');
                const row = $(this).closest('tr');
                row.find('.price').text(newPrice);
                row.find('.price-input').val(newPrice);
                updateSubtotal(row.find('.quantity'));
            });

            $('.quantity').on('change', function() {
                updateSubtotal($(this));
            });

            $('.remove-row').on('click', function() {
                $(this).closest('tr').remove();
                calculateTotal();
            });
        });

        function updateSubtotal(element) {
            const quantity = element.val();
            const row = element.closest('tr');
            const price = row.find('.price-input').val();
            const subtotal = quantity * price;
            row.find('.subtotal').text(subtotal);
            calculateTotal();
        }

        function calculateTotal() {
            let total = 0;
            $('.subtotal').each(function() {
                total += parseFloat($(this).text());
            });
            $('#sub_total').val(total);

            const shippingCost = parseFloat($('#shipping_cost').val() || 0);
            const discount = parseFloat($('#discount').val() || 0);
            const payment = parseFloat($('#payment').val() || 0);

            const finalTotal = total + shippingCost - discount;
            $('#total_amount').val(finalTotal);

            const due = finalTotal - payment;
            $('#collectables').val(due);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/honicma1/demo1.everrivo.com/resources/views/backend/sales/create.blade.php ENDPATH**/ ?>