

<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="<?php echo e(URL::to('')); ?>/public/assets/css/sale.css">

<?php
$general = App\Models\Setting::where('id','=','1')->first();
?>

<div class="content">
   <div class="page-header">
      <div class="page-title">
         <h4>Order Add</h4>
         <h6>Create new Order</h6>
      </div>
   </div>

   <div class="col-lg-12">
      <div class="row">
         <div class="col-lg-6">
            <div class="product-area">
               <div class="container">
                  <div class="col-lg-12">
                     <div class="row">
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-lg-4 col-md-4 col-6 col-sm-6">
                           <div class="single-product-wrap mb-20 wow tmFadeInUp bg-white shadow-sm">
                              <div class="product-img-action-wrap mb-10">
                                 <div class="product-img product-img-zoom">
                                    <img class="default-img" loading="lazy"
                                       src="<?php echo e(URL::to('')); ?>/<?php echo e($row->photo); ?>"
                                       data-src="<?php echo e(URL::to('')); ?>/<?php echo e($row->photo); ?>"
                                       alt="">
                                 </div>
                              </div>
                              <div class="product-content-wrap px-2 pt-0 pb-2">
                                 <div class="title"><?php echo e($row->title); ?></div>
                                 <div class="pro-details-price">
                                    <span id="prices" class="new-price mr-2">Price: <?php echo e($row->offer_price); ?></span>
                                 </div>
                                 <?php if(isset($row->color)): ?>
                                 <div class="color_selector mb-3">
                                    <?php
                                    $colors = explode(',', $row->color);
                                    ?>
                                    <select name="color" id="color_selector" class="form-control color_price">
                                       <option>Select Color</option>
                                       <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       <?php if($loop->index % 2 != 0): ?>
                                       <option value="<?php echo e($colors[$loop->index-1]); ?>" data-img="<?php echo e(URL::to('')); ?>/<?php echo e($color); ?>">
                                          <?php echo e($colors[$loop->index-1]); ?>

                                       </option>
                                       <?php endif; ?>
                                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                 </div>
                                 <?php endif; ?>
                                 <?php
                                 // Fetch size variations for the current product
                                 $productSizeVariations = \App\Models\ProductSizeVariation::where('product_id', $row->id)->get();
                                 ?>
                                 <?php if($productSizeVariations->isNotEmpty()): ?>
                                 <div class="size_selector mb-3">
                                    <select name="size" id="size_selector" class="form-control size_price">
                                       <option>Select Size</option>
                                       <?php $__currentLoopData = $productSizeVariations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       <option value="<?php echo e($variation->size->id); ?>" data-price="<?php echo e($variation->price); ?>">
                                          <?php echo e($variation->size->name); ?>

                                       </option>
                                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                 </div>
                                 <?php endif; ?>
                                 <!-- Hidden input field to store the selected price -->
                                 <input type="hidden" id="sprice" name="sprice" value="<?php echo e($row->offer_price); ?>">
                                 <?php if($row->stock > 0): ?>
                                 <div class="d-flex justify-content-center mb-2 mt-3 your_choice">
                                    <a href="javascript:void(0);" class="button rounded-4 text-center text-rubik text-blue-v2 addtocart" data-id="<?php echo e($row->id); ?>" style="margin-bottom: 0.25rem;">Cart</a>
                                 </div>
                                 <?php else: ?>
                                 <label class="badge bg-danger">Out of stock</label>
                                 <?php endif; ?>
                              </div>
                           </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div>
            rtrt
         </div>
      </div>
   </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
   $(document).ready(function() {
       // Event listener for size selector
       $('#size_selector').on('change', function() {
           var selectedPrice = $(this).find(':selected').data('price');
           $('#prices').text('Price: ' + selectedPrice); // Update displayed price
           $('#sprice').val(selectedPrice); // Update hidden input field with selected price
       });

       // Add to Cart button click handler
       $('.addtocart').click(function(e) {
           e.preventDefault();
           var id = $(this).data('id');
           var quantity = 1; // Assuming quantity is always 1 for now
           var sprice = $('#sprice').val(); // Get the selected price

           var color = $('#color_selector').val(); // Get selected color
           var size = $('#size_selector').val(); // Get selected size

           // Validate selections
           if (!color) {
               showErrorMessage('Please select a color!');
               return;
           }

           if (!size) {
               showErrorMessage('Please select a size!');
               return;
           }

           // AJAX request to add to cart
           var url = '<?php echo e(url('/add-to-cart/')); ?>';
           $.ajax({
               url: url,
               type: "POST",
               data: {
                   id: id,
                   quantity: quantity,
                   color: color,
                   size: size,
                   sprice: sprice,
                   "_token": "<?php echo e(csrf_token()); ?>",
               },
               success: function(response) {
                   console.log(response);
                   Swal.fire({
                       position: 'center',
                       icon: 'success',
                       title: 'Added to cart successfully!',
                       showConfirmButton: false,
                       timer: 1500
                   });

                   // Update cart count and display cart content
                   $('.pro-count').text(response);
                   $("#cartdata").empty();
                   $.ajax({
                       url: '<?php echo e(route('cart.view')); ?>',
                       method: "GET",
                   }).done(function(response) {
                       if (response.length > 0) {
                           $("#cartdata").append(response);
                       }
                   });
               },
               error: function(xhr, status, error) {
                   showErrorMessage('Error adding to cart. Please try again.');
               }
           });
       });

       function showErrorMessage(message) {
           Swal.fire({
               position: 'center',
               icon: 'error',
               title: message,
               showConfirmButton: false,
               timer: 1500
           });
       }
   });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/honicma1/demo1.everrivo.com/resources/views/pos.blade.php ENDPATH**/ ?>