<div class="row no-gutters">
  <div class="col-xl-8">
    <div class="crop-container">
      <img src="<?php echo e($img->url . '?timestamp=' . $img->time); ?>" class="img img-responsive">
    </div>
  </div>
  <div class="col-xl-4">
    <div class="text-center">
      <div class="img-preview center-block"></div>
      <br>
      <div class="btn-group clearfix">
        <label class="btn btn-info btn-aspectRatio active" onclick="changeAspectRatio(this, 16 / 9)">
          16:9
        </label>
        <label class="btn btn-info btn-aspectRatio" onclick="changeAspectRatio(this, 4 / 3)">
          4:3
        </label>
        <label class="btn btn-info btn-aspectRatio" onclick="changeAspectRatio(this, 1)">
          1:1
        </label>
        <label class="btn btn-info btn-aspectRatio" onclick="changeAspectRatio(this, 2 / 3)">
          2:3
        </label>
        <label class="btn btn-info btn-aspectRatio" onclick="changeAspectRatio(this, null)">
          <?php echo e(trans('laravel-filemanager::lfm.btn-crop-free')); ?>

        </label>
      </div>
      <br>
      <br>
      <div class="btn-group clearfix">
        <button class="btn btn-secondary" onclick="loadItems()"><?php echo e(trans('laravel-filemanager::lfm.btn-cancel')); ?></button>
        <button class="btn btn-warning" onclick="performCropNew()"><?php echo e(trans('laravel-filemanager::lfm.btn-copy-crop')); ?></button>
        <button class="btn btn-primary" onclick="performCrop()"><?php echo e(trans('laravel-filemanager::lfm.btn-crop')); ?></button>
      </div>
      <form id='cropForm'>
        <input type="hidden" id="img" name="img" value="<?php echo e($img->name); ?>">
        <input type="hidden" id="working_dir" name="working_dir" value="<?php echo e($working_dir); ?>">
        <input type="hidden" id="dataX" name="dataX">
        <input type="hidden" id="dataY" name="dataY">
        <input type="hidden" id="dataWidth" name="dataWidth">
        <input type="hidden" id="dataHeight" name="dataHeight">
        <input type='hidden' name='_token' value='<?php echo e(csrf_token()); ?>'>
      </form>
    </div>
  </div>
</div>

<script>
    var $image = null,
        options = {};

    $(document).ready(function () {
        var $dataX = $('#dataX'),
            $dataY = $('#dataY'),
            $dataHeight = $('#dataHeight'),
            $dataWidth = $('#dataWidth');

        $image = $('.crop-container > img');
        options = {
            aspectRatio: 16 / 9,
            preview: ".img-preview",
            strict: false,
            crop: function (data) {
                // Output the result data for cropping image.
                $dataX.val(Math.round(data.x));
                $dataY.val(Math.round(data.y));
                $dataHeight.val(Math.round(data.height));
                $dataWidth.val(Math.round(data.width));
            }
        };
        $image.cropper(options);
    });
    function changeAspectRatio(_this, aspectRatio) {
        options.aspectRatio = aspectRatio;
        $('.btn-aspectRatio.active').removeClass('active');
        $(_this).addClass('active');
        $('.img-preview').removeAttr('style');
        $image.cropper('destroy').cropper(options);
        return false;
    }
    function performCrop() {
      performLfmRequest('cropimage', {
        img: $("#img").val(),
        working_dir: $("#working_dir").val(),
        dataX: $("#dataX").val(),
        dataY: $("#dataY").val(),
        dataHeight: $("#dataHeight").val(),
        dataWidth: $("#dataWidth").val(),
        type: $('#type').val()
      }).done(loadItems);
    }

    function performCropNew() {
      performLfmRequest('cropnewimage', {
        img: $("#img").val(),
        working_dir: $("#working_dir").val(),
        dataX: $("#dataX").val(),
        dataY: $("#dataY").val(),
        dataHeight: $("#dataHeight").val(),
        dataWidth: $("#dataWidth").val(),
        type: $('#type').val()
      }).done(loadItems);
    }
</script>
<?php /**PATH /home/honicma1/demo1.everrivo.com/resources/views/vendor/laravel-filemanager/crop.blade.php ENDPATH**/ ?>